package com.spring.boxes.dollar.support.widget;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel(description = "横幅组件")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Banner implements Serializable {

    @ApiModelProperty("编号")
    private long id;

    @ApiModelProperty("引导图")
    private String image;

    @ApiModelProperty("跳转地址")
    private String link;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("子标题")
    private String subtitle;

    @ApiModelProperty("功能介绍")
    private String introduce;

    @ApiModelProperty("宽度")
    private int width;

    @ApiModelProperty("高度")
    private int height;
}
