package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(description = "金刚组件")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Gridbox implements Serializable {

    @ApiModelProperty("序号")
    private long id;

    @ApiModelProperty("主图标")
    private String icon;

    @ApiModelProperty("形状")
    private String shape;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("徽标")
    private String badge;

    @ApiModelProperty("子标题")
    private String subTitle;

    @ApiModelProperty("介绍")
    private String introduce;

    @ApiModelProperty("跳转地址")
    private String link;

    @ApiModelProperty("宽度")
    private int width;

    @ApiModelProperty("高度")
    private int height;

    @ApiModelProperty("大小")
    private int size;

    public Gridbox(long id, String title, String link) {
        this.id = id;
        this.title = title;
        this.link = link;
    }

    public Gridbox(long id, String icon, String title, String link) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.link = link;
    }

    public Gridbox(long id, String icon, String title, String introduce, String link) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.introduce = introduce;
        this.link = link;
    }
}
