package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(description = "格栅组件")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Griddle implements Serializable {

    @ApiModelProperty("序号")
    private long id;

    @ApiModelProperty("主图标")
    private String icon;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("子标题")
    private String subTitle;

    @ApiModelProperty("介绍")
    private String introduce;

    @ApiModelProperty("跳转地址")
    private String link;

    @ApiModelProperty("右角标图标")
    private String arrow;

    @ApiModelProperty("宽度")
    private int width;

    @ApiModelProperty("高度")
    private int height;

    public Griddle(long id, String title, String link) {
        this.id = id;
        this.title = title;
        this.link = link;
    }

    public Griddle(long id, String icon, String title, String link) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.link = link;
    }

    public Griddle(long id, String icon, String title, String introduce, String link) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.introduce = introduce;
        this.link = link;
    }
}
