package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Navbar implements Serializable {

    @ApiModelProperty("导航栏是否固定在顶部")
    private boolean fixed = true;

    @ApiModelProperty("导航栏底部是否显示下边框")
    private boolean border = false;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("导航栏标题的最大宽度，内容超出会以省略号隐藏")
    private int titleWidth;

    @ApiModelProperty("导航背景色")
    private String bgColor;

    @ApiModelProperty("高度")
    private int height;

    @ApiModelProperty("左边的ICON图标")
    private String leftIcon;

    @ApiModelProperty("左边的提示文字")
    private String leftText;

    @ApiModelProperty("左边的跳转地址")
    private String leftLink;

    @ApiModelProperty("右边的ICON图标")
    private String rightIcon;

    @ApiModelProperty("左边的提示文字")
    private String rightText;

    @ApiModelProperty("右边的跳转地址")
    private String rightLink;
}
