package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(description = "轮播组件")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Swiper implements Serializable {

    @ApiModelProperty("是否自动播放")
    private boolean autoplay = true;

    @ApiModelProperty("滑块自动切换时间间隔")
    private int interval = 3000;

    @ApiModelProperty("滑块切换过程所需时间")
    private int duration = 300;

    @ApiModelProperty("播放到末尾后是否重新回到开头")
    private boolean circular;

    @ApiModelProperty("轮播数据")
    private List<Banner> list;
}
