package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(description = "分类组件")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TabList<V> implements Serializable {

    @ApiModelProperty("编号")
    private long id;

    @ApiModelProperty("图标")
    private String icon;

    @ApiModelProperty("分类名称")
    private String name;

    @ApiModelProperty("分类查看更多")
    private String link;

    @ApiModelProperty("分类数据集合")
    private List<V> itemList;

    public TabList(long id, String icon, String name) {
        this.id = id;
        this.icon = icon;
        this.name = name;
    }

    public TabList(long id, String icon, String name, List<V> itemList) {
        this.id = id;
        this.icon = icon;
        this.name = name;
        this.itemList = itemList;
    }

    public TabList(long id, String icon, String name, String link) {
        this.id = id;
        this.icon = icon;
        this.name = name;
        this.link = link;
    }
}
