package com.spring.boxes.dollar.support.widget;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Tabbar implements Serializable {

    @ApiModelProperty("主键编号")
    private long id;

    @ApiModelProperty("选中颜色")
    private String activeStyle;

    @ApiModelProperty("未选中颜色")
    private String inactiveColor;

    @ApiModelProperty("右上角角标")
    private String badge;

    @ApiModelProperty("是否显示边框")
    private boolean border;

    @ApiModelProperty("是否固定在底部")
    private boolean fixed;

    @ApiModelProperty("菜单控件")
    private List<TabbarItem> list;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TabbarItem implements Serializable{

        private String text;

        private String icon;

        private String link;
    }
}
