package com.spring.boxes.dollar.term;

import com.googlecode.aviator.Expression;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface AbView {

    Output EMPTY_OUT = new Output();

    @Data
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    class SceneView implements Serializable {
        private long sceneId;
        private String sceneKey;
        private String sceneName;
        private List<Group> groups;

        @Data
        @ToString
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Group implements Serializable {
            private long sceneId;
            private long groupId;
            private String groupName;
            private String shuntKey;
            private String shuntAlgorithm;
            private String expressions;
            private Expression compiledExpression;
            private List<Item> items;
        }

        @Data
        @ToString
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Item implements Serializable {
            private long sceneId;
            private long groupId;
            private long itemId;
            private String itemName;
            private long itemWeight;
            private List<String> whiteList;
            private List<String> blackList;
            private Map<String, String> carry;
        }

    }

    @Data
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    class Output implements Serializable {
        // 命中对照组
        private List<SceneView.Item> experimentItem;
    }

    @Data
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    class Input implements Serializable {

        // 实验场景
        private String sceneKey;

        // 分流Key
        private String shuntKey;

        // 准入参数
        private Map<String, Object> param;
    }


}
