package com.spring.boxes.dollar.term;

import com.spring.boxes.dollar.support.UniqSupply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@SuperBuilder(toBuilder = true)
@ApiModel(description = "授权用户信息")
public class Authority implements UniqSupply<Long>, Serializable {

    @ApiModelProperty("用户主键账号")
    protected long userId;

    @ApiModelProperty("登录账号")
    protected String account;

    @ApiModelProperty("登录后展示名称")
    protected String showName;

    /*@ApiModelProperty("拥有的资源列表")
    protected Set<String> urls;*/

    //@ApiModelProperty("拥有的角色列表")
    //protected Set<String> roles;

    //@ApiModelProperty("权限列表")
    //protected Set<String> permission;

    @ApiModelProperty("密码")
    protected String password;

    @ApiModelProperty("平台类型")
    protected String platform;

    @ApiModelProperty("盐值")
    protected String salt;

    @ApiModelProperty("有效性")
    protected int enabled;

    public Authority(String showName) {
        this.showName = showName;
    }

    @Override
    public String toString() {
        return this.showName;
    }

    @Override
    public Long getUniqueId() {
        return this.getUserId();
    }
}
