package com.spring.boxes.dollar.term;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Objects;

@Data
@ToString
public class ClientInfo implements Serializable {

    @ApiModelProperty("应用编号")
    private long appId;

    @ApiModelProperty("用户编号")
    private long userId;

    @ApiModelProperty("客户端IP")
    private String clientIp;

    @ApiModelProperty("精度")
    private double longitude;

    @ApiModelProperty("维度")
    private double latitude;

    @ApiModelProperty("设备编号")
    private String deviceId;

    @ApiModelProperty("网络运营商")
    private String isp;

    @ApiModelProperty("网络类型:WIFI")
    private String net;

    @ApiModelProperty("i18n")
    private String locale;

    @ApiModelProperty("浏览器类型")
    private String browserType;

    @ApiModelProperty("浏览器名称")
    private String browserName;

    @ApiModelProperty("浏览器家族")
    private String browserGroup;

    @ApiModelProperty("浏览器版本")
    private String browserVersion;

    @ApiModelProperty("浏览器生产厂商")
    private String browserManufacturer;

    @ApiModelProperty("操作系统名称")
    private String operatingName;

    @ApiModelProperty("访问设备类型")
    private String operatingDeviceType;

    @ApiModelProperty("访问设备家族")
    private String operatingGroup;

    @ApiModelProperty("操作系统生产厂商")
    private String operatingManufacturer;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        @ApiModelProperty("用户编号")
        private long appId;

        @ApiModelProperty("用户编号")
        private long userId;

        @ApiModelProperty("设备编号")
        private String deviceId;

        @ApiModelProperty("i18n")
        private String locale;

        @ApiModelProperty("客户端IP")
        private String clientIp;

        @ApiModelProperty("精度")
        private double longitude;

        @ApiModelProperty("维度")
        private double latitude;

        @ApiModelProperty("网络运营商")
        private String isp;

        @ApiModelProperty("网络类型:WIFI")
        private String net;

        @ApiModelProperty("UserAgent")
        private UserAgent userAgent;

        public Builder appId(long appId) {
            this.appId = appId;
            return this;
        }

        public Builder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public Builder net(String net) {
            this.net = net;
            return this;
        }

        public Builder userAgent(UserAgent userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public ClientInfo build() {
            ClientInfo clientInfo = new ClientInfo();
            if (Objects.nonNull(this.userAgent)) {
                Browser browser = userAgent.getBrowser();
                clientInfo.setBrowserVersion(userAgent.getBrowserVersion().getVersion());
                clientInfo.setBrowserGroup(browser.getGroup().getName());
                clientInfo.setBrowserName(browser.getName());
                clientInfo.setBrowserType(browser.getBrowserType().name());
                clientInfo.setBrowserManufacturer(browser.getManufacturer().name());
                OperatingSystem operatingSystem = userAgent.getOperatingSystem();
                clientInfo.setOperatingName(operatingSystem.getName());
                clientInfo.setOperatingDeviceType(operatingSystem.getDeviceType().name());
                clientInfo.setOperatingGroup(operatingSystem.getGroup().name());
                clientInfo.setOperatingManufacturer(operatingSystem.getManufacturer().name());
            }
            clientInfo.setIsp(this.isp);
            clientInfo.setNet(this.net);
            clientInfo.setLocale(locale);
            clientInfo.setUserId(this.userId);
            clientInfo.setDeviceId(this.deviceId);
            clientInfo.setClientIp(this.clientIp);
            clientInfo.setLatitude(this.latitude);
            clientInfo.setLongitude(this.longitude);
            return clientInfo;
        }
    }

}
