package com.spring.boxes.dollar.term;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// 简易数据模型 可以适配分类、商品、奖品等等
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ItemView implements Serializable {

    @ApiModelProperty("编号")
    private long id;

    @ApiModelProperty("图片地址")
    private String image;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("链接地址")
    private String link;

    @ApiModelProperty("优先级")
    private int priority;

    public ItemView(long id, String image, String name, int priority) {
        this.id = id;
        this.image = image;
        this.name = name;
        this.priority = priority;
    }

    public ItemView(long id, String image, String name, String link) {
        this.id = id;
        this.image = image;
        this.name = name;
        this.link = link;
    }
}
