package com.spring.boxes.dollar.term;

import com.spring.boxes.dollar.support.TreeHandler;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class LocationView extends TreeHandler<LocationView> implements Serializable {

    @ApiModelProperty("城市ID")
    private long id;

    @ApiModelProperty("城市名称")
    private String name;

    @ApiModelProperty("语言")
    private String i18n;

    @ApiModelProperty("缩写")
    private String abbr;

    @ApiModelProperty("拼音")
    private String pinyin;

    @ApiModelProperty("首个字符")
    private String firstChar;

    @ApiModelProperty("纬度")
    private double latitude;

    @ApiModelProperty("经度")
    private double longitude;

    @ApiModelProperty("图片")
    private String image;

    @ApiModelProperty("有效性")
    private String enabled;

    @ApiModelProperty("夫键编号")
    private long parentId;

    @ApiModelProperty("排序优先级")
    private int sort;

    @Override
    public boolean isTreeRoot() {
        return 0 >= this.parentId;
    }

    @Override
    public String getTreeId() {
        return String.valueOf(id);
    }

    @Override
    public String getTreeParentId() {
        return String.valueOf(this.parentId);
    }

}
