package com.spring.boxes.dollar.term;

import cn.dev33.satoken.stp.StpUtil;
import com.spring.boxes.dollar.$;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.cryptor.IdEncryptor;
import io.netty.util.concurrent.FastThreadLocal;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ScopeKey {

    public static final FastThreadLocal<ClientInfo> CLIENT_INFO = new FastThreadLocal<>();

    public static long getUserId() {
        try {
            if(StpUtil.isLogin()){
                return StpUtil.getLoginIdAsLong();
            }
        } catch (Exception e) {
            log.warn(e.getLocalizedMessage(), e);
        }
        return 0;
    }

    public static long getAppId() {
        String appId = System.getProperty("appId");
        if(StringUtils.isBlank(appId)){
            return 0L;
        }
        return Long.parseLong(appId);
    }

    public static String getAppKey(){
        return System.getProperty("appKey");
    }

    public static long getAppIdByKey(String appKey){
        if(StringUtils.isBlank(appKey)){
            appKey = getAppKey();
        }
        if(StringUtils.isBlank(appKey)){
            return 0L;
        }
        return IdEncryptor.skipDecryptId(appKey, IdEncryptor.A);
    }

    public static String getAppKeyById(long appId) {
        if(appId <= 0){
            appId = getAppId();
        }
        if(appId <= 0){
            return StringUtils.EMPTY;
        }
        return IdEncryptor.skipEncryptId(appId, IdEncryptor.A);
    }
}
