package com.spring.boxes.dollar.term;

import com.spring.boxes.dollar.support.TreeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("树形节点模型")
public class TreeView extends TreeHandler<TreeView> implements Serializable {

    @ApiModelProperty("数据ID")
    private long id;

    @ApiModelProperty("数据名称")
    private String name;

    @ApiModelProperty("图标")
    private String icon;

    @ApiModelProperty("图片")
    private String image;

    @ApiModelProperty("类型(非必须)")
    private String type;

    @ApiModelProperty("有效性")
    private String enabled;

    @ApiModelProperty("夫键编号")
    private long parentId;

    @ApiModelProperty("排序优先级")
    private int sort;


    @Override
    public boolean isTreeRoot() {
        return 0 >= this.parentId;
    }

    @Override
    public String getTreeId() {
        return String.valueOf(id);
    }

    @Override
    public String getTreeParentId() {
        return String.valueOf(this.parentId);
    }

}
