package com.spring.boxes.dollar.term;

import java.util.Collection;
import java.util.Map;

import com.fasterxml.jackson.databind.JavaType;
import com.spring.boxes.dollar.JSONUtils;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class TypeValue<V> extends PairView<String, V> {

    // 反序列化, 针对Value为基础类型的结构
    // TypeValue<TermShunt> values = TypeValue.toTypeValue(source, TermShunt.class);
    public static <T> TypeValue<T> toTypeValue(String source, Class<T> valueType) {
        JavaType javaType = JSONUtils.getInstance().getTypeFactory().constructParametricType(TypeValue.class, valueType);
        return JSONUtils.fromJSON(source, javaType);
    }

    // 反序列化, 针对Value为Collection类型的结构
    // TypeValue<List<TermShunt>> values = TypeValue.toTypeValue(source, List.class, TermShunt.class);
    public static <T> TypeValue<T> toTypeValue(String source, Class<? extends Collection> collectionClass, Class<?> elementClass) {
        JavaType javaType = JSONUtils.getInstance().getTypeFactory().constructCollectionType(collectionClass, elementClass);
        return JSONUtils.fromJSON(source, javaType);
    }

    // 反序列化, 针对Value为Map类型的结构
    // TypeValue<HashMap<String,TermShunt>> values = TypeValue.toTypeValue(source, HashMap.class, String.class, TermShunt.class);
    public static <T> TypeValue<T> toTypeValue(String source, Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) {
        JavaType javaType = JSONUtils.getInstance().getTypeFactory().constructMapType(mapClass, keyClass, valueClass);
        return JSONUtils.fromJSON(source, javaType);
    }

    // 使用sample示例
    public static void sample() {
        TypeValue<TermShunt> typeValue = new TypeValue<>();
        typeValue.setKey("typeKey");
        typeValue.setVal(new TermShunt("100", "100;0-99;;"));
        String source = JSONUtils.toJSON(typeValue);
        log.info("序列化:" + source);
        System.out.println(source);
        TypeValue<TermShunt> values = TypeValue.toTypeValue(source, TermShunt.class);
        log.info("反序列化:" + values.getVal().getConfig());
        System.out.println(values.getVal().getConfig());
    }
}
