package com.spring.boxes.dollar.term;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel(value = "ZTreeView", description = "字段名称不能修改")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ZTreeView implements Serializable {

    @ApiModelProperty("节点id")
    private long id;

    @ApiModelProperty("父节点id, 反序列化出去的属性名称必须为pId，ztree组件依赖")
    @JsonProperty("pId")
    private long pId;

    @ApiModelProperty("节点名称")
    private String name;

    @ApiModelProperty("是否打开节点")
    private boolean open;

    @ApiModelProperty("是否被选中")
    private boolean checked;

    public static ZTreeView createParent() {
        ZTreeView zTreeNode = new ZTreeView();
        zTreeNode.setChecked(true);
        zTreeNode.setId(0);
        zTreeNode.setName("顶级");
        zTreeNode.setOpen(true);
        zTreeNode.setPId(0L);
        return zTreeNode;
    }
}
