package com.spring.boxes.dollar.term.virtual;

import java.io.Serializable;
import java.util.Map;

import com.google.common.collect.Maps;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActivityInfo implements Serializable {

    @ApiModelProperty("活动")
    private long id;

    @ApiModelProperty("活动类型")
    private int type;

    @ApiModelProperty("活动Key")
    private String key;

    @ApiModelProperty("活动名称")
    private String name;

    @ApiModelProperty("活动介绍")
    private String introduce;

    @ApiModelProperty("活动状态")
    private int state;

    @ApiModelProperty("活动扩展信息: 奖励奖品、规则跳转地址等等")
    private Map<String, Object> dataValues = Maps.newLinkedHashMap();

    @ApiModelProperty("活动氛围信息: 活动主题皮肤样式等等")
    private Map<String, Object> skinValues = Maps.newLinkedHashMap();
}