/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.googlecode.aviator.annotation.Function;
import com.googlecode.aviator.annotation.Import;
import com.googlecode.aviator.annotation.ImportScope;
import com.spring.boxes.dollar.BeanUtils;
import com.spring.boxes.dollar.CollectionUtils;
import com.spring.boxes.dollar.DSBCUtils;
import com.spring.boxes.dollar.HttpUtils;
import com.spring.boxes.dollar.JoiningUtils;
import com.spring.boxes.dollar.RateUtils;
import com.spring.boxes.dollar.ShuntUtils;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.SystemUtils;
import com.spring.boxes.dollar.TimeUtils;
import com.spring.boxes.dollar.ValueUtils;
import com.spring.boxes.dollar.WebUtils;
import com.spring.boxes.dollar.support.MoreStream;
import com.spring.boxes.dollar.support.TreeFunction;
import com.spring.boxes.dollar.support.TreeHandler;
import com.spring.boxes.dollar.support.cryptor.IdEncryptor;
import com.spring.boxes.dollar.support.cryptor.SkipJack;
import com.spring.boxes.dollar.term.RatePair;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.nlpcn.commons.lang.finger.FingerprintService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Import(ns="dollar", scopes={ImportScope.Static})
public class $ {
    @Generated
    private static final Logger log = LoggerFactory.getLogger($.class);
    public static final Base64.Encoder base64Encoder = Base64.getEncoder();
    public static final Base64.Decoder base64Decoder = Base64.getDecoder();

    public static String getTmpDir() {
        return SystemUtils.getTmpDir();
    }

    public static void openDir(String outputDir) {
        SystemUtils.openDir(outputDir);
    }

    public static String i18nName(Locale locale) {
        return String.format("%s_%s", locale.getCountry(), locale.getLanguage());
    }

    @Function(rename="getAppId")
    public static long getAppId() {
        return Optional.ofNullable(System.getProperty("appId")).map(x -> Long.valueOf(x)).orElse(0L);
    }

    public static String getSystemProperty(String key, String defaultVal) {
        return Optional.ofNullable(System.getProperty(key)).map($::val).orElse(defaultVal);
    }

    public static char val(Character source) {
        return ValueUtils.val(source);
    }

    public static char val(Character source, char defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static float val(Float source) {
        return ValueUtils.val(source);
    }

    public static float val(Float source, float defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static double val(Double source) {
        return ValueUtils.val(source);
    }

    public static double val(Double source, double defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static byte val(Byte source) {
        return ValueUtils.val(source);
    }

    public static byte val(Byte source, byte defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static int val(Integer source) {
        return ValueUtils.val(source);
    }

    public static int val(Integer source, int defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static long val(Long source) {
        return ValueUtils.val(source);
    }

    public static long val(Long source, long defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static String val(String source) {
        return ValueUtils.val(source);
    }

    public static String val(String source, String defaultVal) {
        return ValueUtils.val(source, defaultVal);
    }

    public static String getPoundSubject(String source) {
        return StringUtils.getPoundSubject(source);
    }

    public static String getPoundContent(String source) {
        return StringUtils.getPoundContent(source);
    }

    public static String encode(String source) {
        return Optional.ofNullable(source).map(x -> base64Encoder.encodeToString(source.getBytes(StandardCharsets.UTF_8))).orElse("");
    }

    public static String decode(String source) {
        return Optional.ofNullable(source).map(x -> new String(base64Decoder.decode(source.getBytes(StandardCharsets.UTF_8)))).orElse("");
    }

    public static boolean isHttpUrl(String url) {
        return HttpUtils.isHttpUrl(url);
    }

    public static boolean isHttpsUrl(String url) {
        return HttpUtils.isHttpsUrl(url);
    }

    public static String toDBC(String source) {
        return DSBCUtils.toDBC(source);
    }

    public static String toSBC(String source) {
        return DSBCUtils.toSBC(source);
    }

    public static String toLowerCase(String str) {
        return Optional.ofNullable(str).orElse("").toLowerCase();
    }

    public static String toUpperCase(String str) {
        return Optional.ofNullable(str).orElse("").toUpperCase();
    }

    public static boolean isChinese(String code) {
        return StringUtils.isChinese(code);
    }

    public static boolean isChinese(char c) {
        return StringUtils.isChinese(c);
    }

    @Function(rename="nowTime")
    public static long nowTime() {
        return TimeUtils.now().getTime();
    }

    @Function(rename="nowDate")
    public static Date nowDate() {
        return TimeUtils.now();
    }

    @Function(rename="getAstrologyName")
    public static String getAstrologyName(Date date) {
        return TimeUtils.getAstrologyName(date);
    }

    @Function(rename="getChineseZodiac")
    public static String getChineseZodiac(int year) {
        return TimeUtils.getChineseZodiac(year);
    }

    @Function(rename="getAge")
    public static int getAge(Date birthday) {
        return TimeUtils.getAge(birthday);
    }

    public static Date from(LocalDateTime localDateTime) {
        return TimeUtils.from(localDateTime);
    }

    public static LocalDateTime from(Date date) {
        return TimeUtils.from(date);
    }

    public static String format(Date date, String pattern) {
        return TimeUtils.format(date, pattern);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return TimeUtils.format(localDateTime, pattern);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return TimeUtils.format(localDateTime, dateTimeFormatter);
    }

    public static String format(LocalDate localDate, String pattern) {
        return TimeUtils.format(localDate, pattern);
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter) {
        return TimeUtils.format(localDate, dateTimeFormatter);
    }

    public static String nowFormat(DateTimeFormatter formatter) {
        return TimeUtils.nowFormat(formatter);
    }

    @Function(rename="nowFormat")
    public static String nowFormat(String pattern) {
        return TimeUtils.nowFormat(pattern);
    }

    public static String join(List<String> coll) {
        return JoiningUtils.joinList(coll);
    }

    public static String joinList(List<String> coll, CharSequence delimiter) {
        return JoiningUtils.joinList(coll, delimiter.toString());
    }

    public static List<Long> asLongList(String source) {
        return JoiningUtils.asLongList(source);
    }

    public static List<Integer> asIntegerList(String source) {
        return JoiningUtils.asIntegerList(source);
    }

    public static List<Float> asFloatList(String source) {
        return JoiningUtils.asFloatList(source);
    }

    public static List<Double> asDoubleList(String source) {
        return JoiningUtils.asDoubleList(source);
    }

    public static List<String> asStringList(String source) {
        return JoiningUtils.asStringList(source);
    }

    public static String toJSON(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if ($.isBlank(json)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map jsonToMap(String json) {
        return $.parseObject(json, Map.class);
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target);
    }

    public static String toScore(int score) {
        return String.valueOf(BigDecimal.valueOf(score).divide(BigDecimal.valueOf(10L)).doubleValue());
    }

    public static String toScore(long score) {
        return String.valueOf(BigDecimal.valueOf(score).divide(BigDecimal.valueOf(10L)).doubleValue());
    }

    public static boolean equals(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static boolean deepEquals(Object a, Object b) {
        return Objects.deepEquals(a, b);
    }

    public static int limit(int number, int min, int max) {
        return number <= min ? min : Math.min(number, max);
    }

    public static String likeFull(String source) {
        return Optional.ofNullable(source).map(x -> "%" + org.apache.commons.lang3.StringUtils.trim((String)source) + "%").orElse("");
    }

    public static String likePrefix(String source) {
        return Optional.ofNullable(source).map(x -> "%" + org.apache.commons.lang3.StringUtils.trim((String)source)).orElse("");
    }

    public static boolean isBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cs);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cs);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return org.apache.commons.collections4.CollectionUtils.isEmpty(coll);
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return org.apache.commons.collections4.CollectionUtils.isNotEmpty(coll);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtils.isEmpty(map);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtils.isNotEmpty(map);
    }

    @Function(rename="isOnFor")
    public static boolean isOnFor(String config, long id) {
        return ShuntUtils.isOnFor(config, id);
    }

    @Function(rename="isOnHalf")
    public static boolean isOnHalf(long id) {
        return $.isOnFor("100;0-49;;", id);
    }

    public static <T> List<T> distinct(List<T> list) {
        return MoreStream.distinct(list);
    }

    public static <K, V> Map<K, V> ofConcurrentHashMap(Object ... keysValues) {
        return MoreStream.ofConcurrentHashMap(keysValues);
    }

    public static <T> T getFirst(List<T> list) {
        return MoreStream.getFirst(list);
    }

    public static <T> T getLast(List<T> list) {
        return MoreStream.getLast(list);
    }

    public static <T> List<T> merge(Collection<T> ... coll) {
        return MoreStream.listMerge(coll);
    }

    public static <T> Map<String, T> getPairMap(List<Map<String, T>> list, String keyName, String valName) {
        return CollectionUtils.getPairMap(list, keyName, valName);
    }

    public static String[] split(@Nullable String str, @Nullable String delimiter) {
        return org.springframework.util.StringUtils.delimitedListToStringArray((String)str, (String)delimiter);
    }

    public static String[] split(@Nullable String str) {
        return org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)str);
    }

    public static String trimToNull(String str) {
        return org.apache.commons.lang3.StringUtils.trimToNull((String)str);
    }

    public static String trimToEmpty(String str) {
        return org.apache.commons.lang3.StringUtils.trimToEmpty((String)str);
    }

    public static String substring(String str, int start) {
        return org.apache.commons.lang3.StringUtils.substring((String)str, (int)start);
    }

    public static String substring(String str, int start, int end) {
        return org.apache.commons.lang3.StringUtils.substring((String)str, (int)start, (int)end);
    }

    public static String left(String str, int len) {
        return org.apache.commons.lang3.StringUtils.left((String)str, (int)len);
    }

    public static String right(String str, int len) {
        return org.apache.commons.lang3.StringUtils.right((String)str, (int)len);
    }

    public static String leftPad(String str, int size, char padChar) {
        return org.apache.commons.lang3.StringUtils.leftPad((String)str, (int)size, (char)padChar);
    }

    public static String md5Hex(String data, String salt) {
        return $.md5Hex($.md5Hex(org.apache.commons.lang3.StringUtils.trim((String)data)) + "," + org.apache.commons.lang3.StringUtils.trim((String)salt));
    }

    public static String md5Hex(InputStream inputStream) throws Exception {
        return DigestUtils.md5DigestAsHex((InputStream)inputStream);
    }

    public static String md5Hex(String data) {
        return DigestUtils.md5DigestAsHex((byte[])data.getBytes(Charsets.UTF_8));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    public static String randomNumberString(int size) {
        List<Number> list = $.randomNumberList(size);
        return JoiningUtils.joinList(list, "");
    }

    public static List<Number> randomNumberList(int size) {
        Number[] array = new Number[size];
        Arrays.parallelSetAll(array, index -> ThreadLocalRandom.current().nextInt(9));
        return Arrays.asList(array);
    }

    public static SkipJack toSkipJack(int[] cipher) {
        return SkipJack.of(cipher);
    }

    public static String skipEncrypt(long id, int[] cipher) {
        return IdEncryptor.skipEncryptId(id, cipher);
    }

    public static long skipDecrypt(String encode, int[] cipher) {
        return IdEncryptor.skipDecryptId(encode, cipher);
    }

    @Function(rename="skipEncryptId")
    public static String skipEncryptId(long id) {
        return IdEncryptor.skipEncryptId(id);
    }

    @Function(rename="skipDecryptId")
    public static long skipDecryptId(String encode) {
        return IdEncryptor.skipDecryptId(encode);
    }

    public static long skipEncrypt(long id) {
        return SkipJack.encrypt(id, IdEncryptor.DEFAULT);
    }

    public static long skipDecrypt(long id) {
        return SkipJack.decrypt(id, IdEncryptor.DEFAULT);
    }

    public static <T extends TreeHandler<T>> List<T> toTree(List<T> list) {
        return TreeFunction.tree(list);
    }

    public static String mosaicRoomId(String source) {
        if ($.isBlank(source) || $.trimToEmpty(source).length() < 2) {
            return $.trimToEmpty(source);
        }
        String name = org.apache.commons.lang3.StringUtils.left((String)source, (int)2);
        return org.apache.commons.lang3.StringUtils.rightPad((String)name, (int)org.apache.commons.lang3.StringUtils.length((CharSequence)source), (String)"*");
    }

    public static String repeat(String str, int repeat) {
        return org.apache.commons.lang3.StringUtils.repeat((String)str, (int)repeat);
    }

    public static String repeat(char ch, int repeat) {
        return org.apache.commons.lang3.StringUtils.repeat((char)ch, (int)repeat);
    }

    public static <T> List<T> randomList(List<T> list, int size) {
        return MoreStream.randomList(list, size);
    }

    public static <T> List<T> randomList(Collection<T> list) {
        return MoreStream.randomList(list);
    }

    public static String randomAlphanumeric(int size) {
        return StringUtils.randomAlphanumeric(size);
    }

    public static <T> RatePair<T> getRatePair(List<RatePair<T>> list) {
        return RateUtils.getRatePair(list);
    }

    public static int getRateIndex(List<Integer> rates) {
        return RateUtils.getRateIndex(rates);
    }

    public static List<String> asList(String text) {
        return $.asList(text, ",|\uff0c|\u3001");
    }

    public static List<String> asList(String text, String separatorChars) {
        return $.isNotBlank(text) ? Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)text, (String)separatorChars)) : Lists.newArrayList();
    }

    public static <T> T getService(Class<T> interfaceClass) throws ClassNotFoundException {
        ServiceLoader<T> loader = ServiceLoader.load(interfaceClass);
        Object instance = null;
        for (T object : loader) {
            if (instance != null) {
                throw new ClassNotFoundException("Duplicated classes, " + instance.getClass().getName() + ", " + object.getClass().getName());
            }
            instance = object;
        }
        if (instance == null) {
            throw new ClassNotFoundException("Cannot found provider for [" + interfaceClass + "]");
        }
        return (T)instance;
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        return WebUtils.getRequest();
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return WebUtils.getResponse();
    }

    @Nullable
    public static RequestAttributes getRequestAttributes() {
        return WebUtils.getRequestAttributes();
    }

    @Nullable
    public static HttpHeaders getResponseHeaders(MediaType mediaType) {
        return WebUtils.getResponseHeaders(mediaType);
    }

    @Nullable
    public static HttpSession getSession() {
        return WebUtils.getSession();
    }

    @Nullable
    public static String getCookieVal(String name) {
        return WebUtils.getCookieVal(name);
    }

    @Nullable
    public static String getCookieVal(HttpServletRequest request, String name) {
        return WebUtils.getCookieVal(request, name);
    }

    public static String getRequestIP() {
        return WebUtils.getRequestIP();
    }

    public static void setCookie(String name, @Nullable String value) {
        $.setCookie($.getResponse(), name, value, -1);
    }

    public static void setCookie(String name, @Nullable String value, int maxAgeInSeconds) {
        $.setCookie($.getResponse(), name, value, maxAgeInSeconds);
    }

    public static void setCookie(String domain, String name, @Nullable String value, int maxAgeInSeconds) {
        $.setCookie(domain, "/", name, value, maxAgeInSeconds);
    }

    public static void setCookie(String domain, String path, String name, @Nullable String value, int maxAgeInSeconds) {
        $.setCookie($.getResponse(), domain, path, name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value) {
        $.setCookie(response, name, value, -1);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value, int maxAgeInSeconds) {
        $.setCookie(response, "", name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String domain, String name, @Nullable String value, int maxAgeInSeconds) {
        $.setCookie(response, domain, "/", name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String domain, String path, String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(response, domain, path, name, value, maxAgeInSeconds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Resource toResource(BufferedImage image) {
        try (FastByteArrayOutputStream out = new FastByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)out);
            ByteArrayResource byteArrayResource = new ByteArrayResource(out.toByteArray());
            return byteArrayResource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFile(BufferedImage image, File target) {
        try {
            ImageIO.write((RenderedImage)image, "PNG", target);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ResponseEntity<Resource> toImageEntity(Resource resource) {
        return new ResponseEntity((Object)resource, (MultiValueMap)$.getResponseHeaders(MediaType.IMAGE_PNG), HttpStatus.OK);
    }

    public static ResponseEntity<Resource> toImageEntity(BufferedImage image) {
        Resource resource = $.toResource(image);
        return $.toImageEntity(resource);
    }

    public static ModelAndView toView(String viewPath) {
        return WebUtils.toView(viewPath);
    }

    public static ModelAndView toView(String viewPath, Map context) {
        return WebUtils.toView(viewPath, context);
    }

    public static RedirectView redirect(String uri) {
        return WebUtils.redirect(uri);
    }

    public static String fingerprint(String str) {
        return new FingerprintService().fingerprint(str);
    }
}

