/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.CollectionUtils;
import com.spring.boxes.dollar.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;

public class AssetUtils {
    public static void isTrue(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object o, String message) {
        if (Objects.isNull(o)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(Integer n, String message) {
        if (n == null || n == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(BigDecimal n, String message) {
        if (n == null || n.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(Long n, String message) {
        if (n == null || n == 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void sholdDigits(String str, String message) {
        if (!NumberUtils.isDigits((String)str)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBlank(String str, String message) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmail(String email) {
        String check = "^([a-zA-Z0-9]+[-_.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[-_.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,6}$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(email);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1");
        }
    }

    public static void notMobile(String mobile) {
        String check = "^1[3-9]\\d{9}$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(mobile);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
        }
    }

    public static void notIDNumber(String IDNumber) {
        String id_18 = "^[1-9][0-9]{5}(18|19|20)[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{3}([0-9]|(X|x))";
        String id_15 = "^[1-9][0-9]{5}[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{2}[0-9]";
        String check = "(" + id_18 + ")|(" + id_15 + ")";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(IDNumber);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
        }
    }
}

