/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import java.util.Optional;

public class DSBCUtils {
    private static final char DBC_CHAR_START = '!';
    private static final char DBC_CHAR_END = '~';
    private static final char SBC_CHAR_START = '\uff01';
    static final char SBC_CHAR_END = '\uff5e';
    private static final char SBC_SPACE = '\u3000';
    private static final int CONVERT_STEP = 65248;
    private static final char DBC_SPACE = ' ';

    public static String toDBC(String src) {
        return Optional.ofNullable(src).map(e -> {
            char[] ca = e.toCharArray();
            StringBuilder buf = new StringBuilder(ca.length);
            for (char c : ca) {
                if (c >= '\uff01' && c <= '\uff5e') {
                    buf.append((char)(c - 65248));
                    continue;
                }
                if (c == '\u3000') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }).orElse("");
    }

    public static String toSBC(String src) {
        return Optional.ofNullable(src).map(e -> {
            char[] ca = e.toCharArray();
            StringBuilder buf = new StringBuilder(ca.length);
            for (char c : ca) {
                if (c == ' ') {
                    buf.append('\u3000');
                    continue;
                }
                if (c >= '!' && c <= '~') {
                    buf.append((char)(c + 65248));
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }).orElse("");
    }
}

