/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.spring.boxes.dollar.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtils
extends org.apache.commons.io.FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String DEFAULT_PATH = "default";

    public static boolean checkFileSize(MultipartFile file, int size, String unit) {
        if (file.isEmpty() || size == 0 || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)unit)) {
            return false;
        }
        long len = file.getSize();
        double fileSize = 0.0;
        if ("B".equals(unit.toUpperCase())) {
            fileSize = len;
        } else if ("K".equals(unit.toUpperCase())) {
            fileSize = (double)len / 1024.0;
        } else if ("M".equals(unit.toUpperCase())) {
            fileSize = (double)len / 1048576.0;
        } else if ("G".equals(unit.toUpperCase())) {
            fileSize = (double)len / 1.073741824E9;
        }
        return !(fileSize > (double)size);
    }

    public static String getEncodeFilename(String fileName) {
        return new String(fileName.getBytes(Charset.forName("ISO8859-1")), StandardCharsets.UTF_8);
    }

    public static String getOriginalFilename(MultipartFile file) {
        return Optional.ofNullable(file.getOriginalFilename()).orElse("");
    }

    public static String getOriginalFilename(File file) {
        return Optional.of(file.getName()).orElse("");
    }

    public static String digestRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return "";
        }
        String newName = DigestUtils.md5Hex((String)originName) + FileUtils.getTimeMillisTail(5);
        return String.format("%s.%s", newName, FilenameUtils.getExtension((String)originName)).toLowerCase();
    }

    public static String snowRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return "";
        }
        String newName = IdWorker.getIdStr() + FileUtils.getTimeMillisTail(5);
        return String.format("%s.%s", newName, FilenameUtils.getExtension((String)originName)).toLowerCase();
    }

    public static String uuidRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return "";
        }
        return UUID.randomUUID() + "." + FilenameUtils.getExtension((String)originName).toLowerCase();
    }

    public static void download(String urlAddr, String downLoadPath) {
        if (StringUtils.isBlank(urlAddr)) {
            return;
        }
        try {
            org.apache.commons.io.FileUtils.copyURLToFile((URL)new URL(urlAddr), (File)new File(downLoadPath + "/" + FileUtils.digestRename(urlAddr)));
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getStorePath(int year, int month, int day, String storeName) {
        return FileUtils.getStorePath(null, year, month, day, storeName);
    }

    public static String getStorePath(DateTime dateTime, String storeName) {
        return FileUtils.getStorePath(null, dateTime, storeName);
    }

    public static String getStorePath(String rootPath, DateTime dateTime, String storeName) {
        String savedPath = StringUtils.isBlank(rootPath) ? DEFAULT_PATH : StringUtils.trim(rootPath);
        return String.format("%s/%s-%s-%s/%s", savedPath, dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), storeName);
    }

    public static String getStorePath(String rootPath, int year, int month, int day, String storeName) {
        String savedPath = StringUtils.isBlank(rootPath) ? DEFAULT_PATH : StringUtils.trim(rootPath);
        return String.format("%s/%s-%s-%s/%s", savedPath, year, month, day, storeName);
    }

    public static String getTimeMillisTail(int size) {
        return String.valueOf(System.currentTimeMillis()).substring(13 - size, 13);
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

