/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.support.cryptor.Base62;
import com.spring.boxes.dollar.support.cryptor.IdEncryptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HackIdUtils {
    private static final String FORMAT = "%s_%s";
    private static final String DELIMIT = "_";

    public static String encodeId(long id) {
        return Base62.toBase62(IdEncryptor.skipEncrypt(id));
    }

    public static long decodeId(String uuid) {
        return IdEncryptor.skipDecrypt(Base62.toLongVal(uuid));
    }

    public static long decodeId(String uuid, long defaultVal) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return defaultVal;
        }
        return HackIdUtils.decodeId(uuid);
    }

    public static String encodeTypeId(int type, long id) {
        return String.format(FORMAT, Base62.toBase62(IdEncryptor.skipEncrypt(type)), Base62.toBase62(IdEncryptor.skipEncrypt(id)));
    }

    public static Pair<Integer, Long> decodeTypeId(String account) {
        if (StringUtils.isBlank((CharSequence)account) || !account.contains(DELIMIT)) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8d26\u53f7");
        }
        String[] arr = account.split(DELIMIT);
        if (ArrayUtils.getLength((Object)arr) != 2) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8d26\u53f7");
        }
        long type = IdEncryptor.skipDecrypt(Base62.toLongVal(arr[0]));
        long id = IdEncryptor.skipDecrypt(Base62.toLongVal(arr[1]));
        return Pair.of((Object)((int)type), (Object)id);
    }
}

