/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ArrayUtils;
import org.hashids.Hashids;

public class HashUtils {
    public static final int LEN_DEF = 19;
    public static final String SALT_DEF = "boxes";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz";
    public static final Hashids HASHIDS = new Hashids("boxes", 19, "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz");

    public static String nanoTime() {
        return HASHIDS.encode(new long[]{System.nanoTime()});
    }

    public static String encode(long source) {
        return HASHIDS.encode(new long[]{source});
    }

    public static long decode(String source) {
        long[] arr = HASHIDS.decode(source);
        Preconditions.checkArgument((ArrayUtils.getLength((Object)arr) == 1 ? 1 : 0) != 0, (Object)"\u683c\u5f0f\u9519\u8bef");
        return arr[0];
    }

    public static String encodeHex(String source) {
        return HASHIDS.encodeHex(source);
    }

    public static String decodeHex(String source) {
        return HASHIDS.decodeHex(source);
    }

    public static Hashids instance() {
        return HashUtils.instance(19);
    }

    public static Hashids instance(int minHashLength) {
        return HashUtils.instance(SALT_DEF, minHashLength, ALPHABET);
    }

    public static Hashids instance(String salt, int minHashLength) {
        return HashUtils.instance(salt, minHashLength, ALPHABET);
    }

    public static Hashids instance(String salt, int minHashLength, String alphabet) {
        return new Hashids(salt, minHashLength, alphabet);
    }
}

