/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.term.Endpoint;
import com.spring.boxes.dollar.term.HttpPoint;
import com.spring.boxes.dollar.term.RatePair;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";

    @Deprecated
    public static boolean isHttpUrl(String url) {
        return Endpoint.isHttp(url);
    }

    @Deprecated
    public static boolean isHttpsUrl(String url) {
        return Endpoint.isHttps(url);
    }

    @Deprecated
    public static boolean isHttpOrHttpsUrl(String url) {
        return Endpoint.isHttpOrHttps(url);
    }

    @Deprecated
    public static String getHttpPoint(List<RatePair<String>> weights) {
        return (String)Endpoint.getEndpoint(weights);
    }

    @Deprecated
    public static String getHttpsUrl(String url) {
        return Endpoint.toHttps(url);
    }

    @Deprecated
    public static String getHttpUrl(String url) {
        return Endpoint.toHttps(url);
    }

    public static String getTargetUrl(HttpPoint config, String url) {
        if (!HttpUtils.isHttpOrHttpsUrl(url)) {
            return url;
        }
        if (Objects.isNull(config) || StringUtils.isBlank((CharSequence)config.getScheme())) {
            throw new IllegalArgumentException("\u57df\u540d\u53c2\u6570\u914d\u7f6e\u9519\u8bef");
        }
        String protocol = config.getScheme();
        List accept = ListUtils.emptyIfNull(config.getAccept());
        List target = ListUtils.emptyIfNull(config.getTarget());
        try {
            URI urlObj = new URI(url);
            String schema = urlObj.getScheme();
            String host = urlObj.getHost();
            String path = urlObj.getPath();
            if (!StringUtils.isEmpty((CharSequence)protocol)) {
                schema = protocol;
            }
            if (accept.contains(host)) {
                host = HttpUtils.getHttpPoint(target);
            }
            return schema + "://" + host + path;
        }
        catch (Throwable e) {
            return url;
        }
    }
}

