/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class JSONUtils {
    public static final String EMPTY_JSON = "{}";
    public static final String EMPTY_ARRAY_JSON = "[]";
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final ParseContext PARSE_CONTEXT;

    public static String toPrettyJSON(@Nullable Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw JSONUtils.JSONException((IOException)((Object)e));
        }
    }

    public static String toJSON(@Nullable Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw JSONUtils.JSONException((IOException)((Object)e));
        }
    }

    public static <T> T fromJSON(@Nullable String json, Class<T> valueType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueType);
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <T> T fromJSON(@Nullable String json, JavaType javaType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <E, T extends Collection> T fromJSON(String json, Class<? extends Collection> collectionType, Class<E> valueType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = EMPTY_ARRAY_JSON;
        }
        try {
            return (T)((Collection)OBJECT_MAPPER.readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(collectionType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <E, T extends Collection> T fromJSON(byte[] bytes, Class<? extends Collection> collectionType, Class<E> valueType) {
        try {
            return (T)((Collection)OBJECT_MAPPER.readValue(bytes, (JavaType)TypeFactory.defaultInstance().constructCollectionType(collectionType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <E, T extends Collection> T fromJSON(InputStream inputStream, Class<? extends Collection> collectionType, Class<E> valueType) {
        try {
            return (T)((Collection)OBJECT_MAPPER.readValue(inputStream, (JavaType)TypeFactory.defaultInstance().constructCollectionType(collectionType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static Map<String, Object> fromJSON(String json) {
        return JSONUtils.fromJSON(json, Map.class, String.class, Object.class);
    }

    public static Map<String, Object> fromJSON(InputStream is) {
        return JSONUtils.fromJSON(is, Map.class, String.class, Object.class);
    }

    public static Map<String, Object> fromJSON(byte[] bytes) {
        return JSONUtils.fromJSON(bytes, Map.class, String.class, Object.class);
    }

    public static <K, V, T extends Map<K, V>> T fromJSON(String json, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = EMPTY_JSON;
        }
        try {
            return (T)((Map)OBJECT_MAPPER.readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(mapType, keyType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <K, V, T extends Map<K, V>> T fromJSON(byte[] bytes, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        try {
            return (T)((Map)OBJECT_MAPPER.readValue(bytes, (JavaType)TypeFactory.defaultInstance().constructMapType(mapType, keyType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <K, V, T extends Map<K, V>> T fromJSON(InputStream inputStream, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        try {
            return (T)((Map)OBJECT_MAPPER.readValue(inputStream, (JavaType)TypeFactory.defaultInstance().constructMapType(mapType, keyType, valueType)));
        }
        catch (IOException e) {
            throw JSONUtils.JSONException(e);
        }
    }

    public static <T> T extractJsonPathAsObject(Object argument, String jsonPath) {
        String json = JSONUtils.toJSON(argument);
        return JSONUtils.extractJsonPathAsObject(json, jsonPath);
    }

    public static <T> T extractJsonPathAsObject(String json, String jsonPath) {
        return (T)JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    public static <T> T extractJsonPathAsObject(Object argument, String jsonPath, TypeRef<T> typeRef) {
        String json = JSONUtils.toJSON(argument);
        return JSONUtils.extractJsonPathAsObject(json, jsonPath, typeRef);
    }

    public static <T> T extractJsonPathAsObject(String json, String jsonPath, TypeRef<T> typeRef) {
        return (T)PARSE_CONTEXT.parse(json).read(jsonPath, typeRef);
    }

    public static <T> T extractJsonPathAsObject(DocumentContext ctx, String jsonPath, TypeRef<T> typeRef) {
        return (T)ctx.read(jsonPath, typeRef);
    }

    public static <T> T extractJsonPathAsObject(Object argument, String jsonPath, Class<T> type) {
        String json = JSONUtils.toJSON(argument);
        return JSONUtils.extractJsonPathAsObject(json, jsonPath, type);
    }

    public static <T> T extractJsonPathAsObject(String json, String jsonPath, Class<T> type) {
        return (T)PARSE_CONTEXT.parse(json).read(jsonPath, type, new Predicate[0]);
    }

    public static <T> T extractJsonPathAsObject(DocumentContext ctx, String jsonPath, Class<T> type) {
        return (T)ctx.read(jsonPath, type, new Predicate[0]);
    }

    private static RuntimeException JSONException(IOException e) {
        if (e instanceof JsonProcessingException) {
            return new UncheckedExecutionException((Throwable)e);
        }
        return new UncheckedIOException(e);
    }

    private static JavaTimeModule javaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_PATTERN)));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_PATTERN)));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_PATTERN)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_PATTERN)));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_PATTERN)));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_PATTERN)));
        return javaTimeModule;
    }

    public static ObjectMapper getInstance() {
        return OBJECT_MAPPER;
    }

    static {
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DEFAULT_DATE_TIME_PATTERN));
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule()).registerModules(new Module[]{new GuavaModule(), new ParameterNamesModule(), new KotlinModule(), new Jdk8Module()});
        PARSE_CONTEXT = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper())).mappingProvider((MappingProvider)new JacksonMappingProvider(JSONUtils.getInstance())).build().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}));
    }
}

