/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.WebUtils;
import com.spring.boxes.dollar.support.Language;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

public class LanguageUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LanguageUtils.class);
    private static final List<Locale> ALL_LOCALES = Arrays.stream(Language.values()).map(Language::getLocale).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    private static final Map<String, Locale> LOCALE_MAP = Stream.of(Language.values()).filter(Objects::nonNull).collect(Collectors.toMap(v -> LanguageUtils.toMapKey(LocaleUtils.toLocale((String)v.name())), Language::getLocale));

    private static String toMapKey(Locale locale) {
        if (StringUtils.isEmpty((CharSequence)locale.getCountry())) {
            return locale.getLanguage();
        }
        return locale.getLanguage() + "#" + locale.getCountry();
    }

    private static Locale chooseLocale(Locale locale) {
        if (Objects.isNull(locale)) {
            return Locale.CHINESE;
        }
        String language = locale.getLanguage();
        Locale result = LOCALE_MAP.get(LanguageUtils.toMapKey(locale));
        if (Objects.isNull(result)) {
            result = LOCALE_MAP.get(language);
        }
        return Objects.nonNull(result) ? result : Locale.ENGLISH;
    }

    public static List<Locale> getAllResourceLocales() {
        return ALL_LOCALES;
    }

    public static String getMessage(Locale locale, String key) {
        String message = LanguageUtils.getMessageMap(locale).get(key);
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = LanguageUtils.getMessageMap(Locale.US).get(key);
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = LanguageUtils.getMessageMap(Locale.CHINA).get(key);
        }
        return message;
    }

    public static Map<String, String> getMessageMap(Locale locale) {
        String language = LanguageUtils.chooseLocale(locale).toString();
        return (Map)LazyHolder.languageResourceMap.get(language);
    }

    public static RedirectView settingLocale(String locale) {
        HttpServletRequest request = WebUtils.getRequest();
        HttpServletResponse response = WebUtils.getResponse();
        assert (request != null);
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        assert (localeResolver != null);
        if (Locale.US.getLanguage().equals(locale)) {
            localeResolver.setLocale(request, response, Locale.US);
        }
        if (Locale.CHINA.getLanguage().equals(locale)) {
            localeResolver.setLocale(request, response, Locale.CHINA);
        }
        if (StringUtils.isBlank((CharSequence)request.getHeader("Referer"))) {
            return WebUtils.redirect("/");
        }
        return WebUtils.redirect(request.getHeader("Referer"));
    }

    private static class LazyHolder {
        private static final Map<String, Map<String, String>> languageResourceMap = new HashMap<String, Map<String, String>>();

        private LazyHolder() {
        }

        private static Map<String, String> generateLangMap(Locale locale) {
            HashMap<String, String> map = new HashMap<String, String>();
            ResourceBundle bundle = ResourceBundle.getBundle("message", locale);
            Enumeration<String> enu = bundle.getKeys();
            while (enu.hasMoreElements()) {
                String key = enu.nextElement();
                String value = bundle.getString(key);
                map.put(key, value);
            }
            return map;
        }

        static {
            for (Language language : Language.values()) {
                languageResourceMap.put(language.name(), LazyHolder.generateLangMap(language.getLocale()));
            }
        }
    }
}

