/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.term.RatePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateUtils.class);

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList();
        list.add(new RatePair<String>(1, "10001L"));
        list.add(new RatePair<String>(2, "10002L"));
        list.add(new RatePair<String>(3, "10003L"));
        list.add(new RatePair<String>(4, "10004L"));
        list.add(new RatePair<String>(90, "10005L"));
        System.out.println(RateUtils.getRatePair(list));
    }

    public static <T> RatePair<T> getRatePair(List<RatePair<T>> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("\u6743\u91cd\u96c6\u5408\u4e3a\u7a7a");
        }
        double sumRate = list.stream().mapToDouble(RatePair::getRate).sum();
        log.info("[\u4e8b\u4ef6\u6982\u7387]\u603b\u6982\u7387:{}", (Object)sumRate);
        ArrayList sortRates = Lists.newArrayListWithCapacity((int)(list.size() + 1));
        double tempRate = 0.0;
        for (RatePair<T> idWeight : list) {
            sortRates.add((tempRate += (double)idWeight.getRate()) / sumRate);
        }
        double nextRate = Math.random();
        sortRates.add(nextRate);
        Collections.sort(sortRates);
        log.info("[\u4e8b\u4ef6\u6982\u7387]\u6982\u7387\u96c6:{}", (Object)sortRates);
        return list.get(sortRates.indexOf(nextRate));
    }

    public static int getRateIndex(List<Integer> rates) {
        int total = rates.stream().mapToInt(Integer::intValue).sum();
        if (total == 0) {
            return 0;
        }
        int random = RandomUtils.nextInt((int)0, (int)total);
        int offset = 0;
        for (int i = 0; i < rates.size(); ++i) {
            int rate = rates.get(i);
            if (random >= offset && random < offset + rate) {
                return i;
            }
            offset += rate;
        }
        return rates.size() - 1;
    }
}

