/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtils {
    public static final String NUMBER = "^[0-9]*$";
    public static final String USER_NAME = "^[a-zA-Z\\u4E00-\\u9FA5][a-zA-Z0-9_\\u4E00-\\u9FA5]{1,11}$";
    public static final String USER_PASSWORD = "^.{6,32}$";
    public static final String EMAIL = "^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    public static final String PHONE = "^1[3-9]\\d{9}$";
    public static final String EMAIL_OR_PHONE = "^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$|^1[3-9]\\d{9}$";
    public static final String URL = "^(https?:\\/\\/)?([\\da-z\\.-]+)\\.([a-z\\.]{2,6})(:[\\d]+)?([\\/\\w\\.-]*)*\\/?$";
    public static final String ID_CARD = "^\\d{15}$|^\\d{17}([0-9]|X)$";
    public static final String DOMAIN = "^[0-9a-zA-Z]+[0-9a-zA-Z\\.-]*\\.[a-zA-Z]{2,4}$";
    public static final String CHN_PHONE = "^[1][3-8]\\d{9}$";
    public static final String HK_OR_MO_PHONE = "^(([6|9])\\d{7})|([86]([8|6])\\d{5})$";
    public static final String TW_PHONE = "^[0][9]\\d{8}$";
    public static final String TELEPHONE = "^((0\\d{2,3})-?)(\\d{7,8})(-?(\\d{3,}))?$";
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final Pattern GENERAL = Pattern.compile("^\\w+$");
    public static final Pattern ZIP_CODE = Pattern.compile("\\d{6}");

    public static boolean isIpv4(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        String regex = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
        return Pattern.matches(regex, ip);
    }

    @Deprecated
    public static boolean isMatch(String source, String regex) {
        return Pattern.matches(regex, source);
    }
}

