/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.Vector;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SftpUtils.class);

    public static ChannelSftp connect(String host, int port, String username, String password) {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, port);
            Session sshSession = jsch.getSession(username, host, port);
            sshSession.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            log.error("\u8fde\u63a5Sftp\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u786e\u8ba4ftp\u8fde\u63a5\u53c2\u6570\u662f\u5426\u8bbe\u7f6e\u6b63\u786e", (Throwable)e);
        }
        return sftp;
    }

    public static void disconnect(ChannelSftp sftp) {
        if (null != sftp) {
            if (sftp.isConnected()) {
                sftp.disconnect();
            }
            sftp.quit();
            try {
                Session session = sftp.getSession();
                if (session.isConnected()) {
                    session.disconnect();
                }
            }
            catch (JSchException e) {
                log.error("\u4ecesftp\u83b7\u53d6session\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void upload(String directory, String uploadFile, String saveFile, ChannelSftp sftp) {
        SftpUtils.upload(directory, new File(uploadFile), saveFile, sftp);
    }

    public static void upload(String directory, File file, String saveFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            if (saveFile != null && saveFile.length() > 0) {
                sftp.put(Files.newInputStream(file.toPath(), new OpenOption[0]), saveFile);
            } else {
                sftp.put(Files.newInputStream(file.toPath(), new OpenOption[0]), file.getName());
            }
        }
        catch (Exception e) {
            log.error("upload has error", (Throwable)e);
        }
    }

    public void download(String directory, String downloadFile, String saveFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            File file = new File(saveFile);
            sftp.get(downloadFile, Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            log.error("download has error", (Throwable)e);
        }
    }

    public void delete(String directory, String deleteFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            sftp.rm(deleteFile);
        }
        catch (Exception e) {
            log.error("delete has error", (Throwable)e);
        }
    }

    public Vector listFiles(String directory, ChannelSftp sftp) throws SftpException {
        return sftp.ls(directory);
    }
}

