/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ShuntUtils {
    public static final String DEFAULT = ";;;";

    public static boolean isOnHalf(long id) {
        return ShuntUtils.isOnFor("100;0-49;;", id);
    }

    public static boolean isOnFor(String config, long id) {
        return ShuntUtils.isOnFor(LongUnaryOperator.identity(), config, id);
    }

    public static boolean isOnFor(LongUnaryOperator preHashFunction, String config, long id) {
        if (StringUtils.isBlank((CharSequence)config)) {
            return false;
        }
        Object[] segments = config.split(";");
        if (ArrayUtils.isEmpty((Object[])segments)) {
            return false;
        }
        if (segments.length < 1) {
            throw new IllegalArgumentException("\u683c\u5f0f\u683c\u5f0f\u65e0\u6548! \u6b63\u786e\u683c\u5f0f: \"100;0-49;123,456;111,222\", \u5f53\u524d\u683c\u5f0f: " + config);
        }
        int mod = StringUtils.isNotBlank((CharSequence)segments[0]) ? Integer.parseInt((String)segments[0]) : 0;
        TreeRangeSet tailNumbers = null;
        if (segments.length >= 2 && StringUtils.isNotBlank((CharSequence)segments[1])) {
            String[] ranges;
            tailNumbers = TreeRangeSet.create();
            for (String range : ranges = ((String)segments[1]).split(",")) {
                long upper;
                if (!range.contains("-")) {
                    long num = Long.parseLong(range);
                    tailNumbers.add(Range.closed((Comparable)Long.valueOf(num), (Comparable)Long.valueOf(num)).canonical(DiscreteDomain.longs()));
                    continue;
                }
                String[] nums = range.split("-");
                long lower = Long.parseLong(nums[0]);
                if (lower >= (upper = Long.parseLong(nums[1]))) {
                    throw new IllegalArgumentException("\u65e0\u6548\u533a\u95f4: " + range);
                }
                tailNumbers.add(Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper)).canonical(DiscreteDomain.longs()));
            }
        }
        Set<Long> whiteList = ShuntUtils.parseList((String[])segments, 2);
        Set<Long> blackList = ShuntUtils.parseList((String[])segments, 3);
        return ShuntUtils.isOnFor(preHashFunction, mod, (RangeSet<Long>)tailNumbers, whiteList, blackList, id);
    }

    private static boolean isOnFor(LongUnaryOperator hashFunc, long mod, RangeSet<Long> tailNumbers, Set<Long> whiteList, Set<Long> blackList, long id) {
        hashFunc = Optional.ofNullable(hashFunc).orElse(LongUnaryOperator.identity());
        whiteList = Optional.ofNullable(whiteList).orElse(Collections.emptySet());
        if ((blackList = Optional.ofNullable(blackList).orElse(Collections.emptySet())).isEmpty() && ShuntUtils.isAllTail(mod, tailNumbers)) {
            return true;
        }
        if (blackList.contains(id)) {
            return false;
        }
        long tailNumber = ShuntUtils.getTail(hashFunc, mod, id);
        if (mod > 0L && tailNumbers.contains((Comparable)Long.valueOf(tailNumber))) {
            return true;
        }
        return whiteList.contains(id);
    }

    private static long getTail(LongUnaryOperator preHashFunction, long mod, long id) {
        if (mod > 0L) {
            long hashed = preHashFunction.applyAsLong(id);
            return (hashed % mod + mod) % mod;
        }
        return 0L;
    }

    private static boolean isAllTail(long mod, RangeSet<Long> tailNumbers) {
        return mod > 0L && tailNumbers.encloses(Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(mod - 1L)));
    }

    private static Set<Long> parseList(String[] segments, int index) {
        if (index >= segments.length || StringUtils.isBlank((CharSequence)segments[index])) {
            return Collections.emptySet();
        }
        return Arrays.stream(segments[index].split(",")).map(x -> Long.parseLong(StringUtils.trim((String)x))).collect(Collectors.toSet());
    }

    public static void main(String[] args) {
        String config = "100;0-99;123,456;111,222";
        for (int i = 0; i < 10; ++i) {
            System.out.println(ShuntUtils.isOnFor(config, i));
        }
        System.out.println("\u6d4b\u8bd5\u9ed1\u767d\u540d\u5355");
        System.out.println(ShuntUtils.isOnFor(config, 123L));
        System.out.println(ShuntUtils.isOnFor(config, 456L));
        System.out.println(ShuntUtils.isOnFor(config, 111L));
        System.out.println(ShuntUtils.isOnFor(config, 222L));
    }

    @Generated
    private ShuntUtils() {
    }
}

