/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.google.common.base.Throwables;
import com.spring.boxes.dollar.DSBCUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.text.StringSubstitutor;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String ZERO = "0";
    public static final long _10_000 = 10000L;
    public static final long _100_000_000 = 100000000L;

    public static boolean isNotBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cs);
    }

    public static boolean isBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cs);
    }

    public static String trimToEmpty(String str) {
        return org.apache.commons.lang3.StringUtils.trimToEmpty((String)str);
    }

    public static String randomAlphanumeric(int size) {
        return RandomStringUtils.random((int)size, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)ThreadLocalRandom.current());
    }

    public static String substitutor(String source, Map<String, Object> valueMap) {
        StringSubstitutor stringSubstitutor = new StringSubstitutor(valueMap, "${", "}");
        return stringSubstitutor.replace(source);
    }

    public static String toDBC(String source) {
        return DSBCUtils.toDBC(source);
    }

    public static String toSBC(String source) {
        return DSBCUtils.toSBC(source);
    }

    public static String getPoundSubject(String source) {
        return Optional.ofNullable(DSBCUtils.toDBC(source)).map(e -> {
            int low = -1;
            int top = -1;
            for (int i = 0; i < e.length(); ++i) {
                if (Objects.equals(Character.valueOf('#'), Character.valueOf(e.charAt(i))) && low == -1) {
                    low = i;
                    continue;
                }
                if (!Objects.equals(Character.valueOf('#'), Character.valueOf(e.charAt(i)))) continue;
                top = i;
                break;
            }
            if (low < top && 0 != top) {
                return e.substring(low + 1, top);
            }
            return EMPTY;
        }).orElse(EMPTY);
    }

    public static String getPoundContent(String source) {
        String subject = StringUtils.getPoundSubject(source);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)subject)) {
            return org.apache.commons.lang3.StringUtils.trimToEmpty((String)source);
        }
        return source.substring(subject.length() + 2);
    }

    public static String trim(String str) {
        return org.apache.commons.lang3.StringUtils.trim((String)str);
    }

    public static boolean isChinese(char c) {
        Character.UnicodeScript sc = Character.UnicodeScript.of(c);
        return sc == Character.UnicodeScript.HAN;
    }

    public static boolean isChinese(String code) {
        char[] cArray;
        int n;
        int n2;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)code) && (n2 = 0) < (n = (cArray = code.toCharArray()).length)) {
            char codeBit = cArray[n2];
            return StringUtils.isChinese(codeBit);
        }
        return false;
    }

    public static String getWatchText(long count) {
        if (count < 10000L) {
            return String.valueOf(count);
        }
        if (count >= 100000000L) {
            return StringUtils.cellingScale(count, 100000000L, 2) + "\u4ebf";
        }
        return StringUtils.cellingScale(count, 10000L, 1) + "w";
    }

    private static double cellingScale(long left, long right, int scale) {
        return BigDecimal.valueOf(left).divide(BigDecimal.valueOf(right), scale, RoundingMode.CEILING).doubleValue();
    }

    public static String uuidSalt() {
        return UUID.randomUUID().toString().replaceAll("-", EMPTY);
    }

    public static String getExceptionName(Throwable e) {
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        return ClassUtils.getShortClassName((Object)rootCause, (String)EMPTY);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(StringUtils.randomAlphanumeric(16));
        }
    }
}

