/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.term.TimeZone;
import io.netty.util.internal.ThreadLocalRandom;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class TimeUtils {
    public static final String[] ZODIAC_NAMES = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final String[] ASTROLOGY_NAMES = new String[]{"\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7"};
    public static final String[] WEEK_DAYS = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_YMD_INT = "yyyyMMdd";
    public static final String PATTERN_WEEK = "EEEE";
    public static final ZoneId CHINA_ZONE_ID = ZoneId.of("Asia/Shanghai");

    public static Date now() {
        return new Date();
    }

    public static long toMilliseconds(Date date) {
        return date.getTime();
    }

    public static long toMilliseconds(LocalDate localDate) {
        return TimeUtils.toMilliseconds(localDate.atStartOfDay());
    }

    public static long toMilliseconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Date toDate(long timestamp) {
        return new Date(timestamp);
    }

    public static LocalDate toLocalDate(long timestamp) {
        return TimeUtils.toLocalDateTime(timestamp).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return TimeUtils.from(TimeUtils.toDate(timestamp));
    }

    public static boolean isNowOn(TimeZone zoneTime, long now) {
        return zoneTime.getStartTime() < now && zoneTime.getStopTime() > now;
    }

    public static boolean isNowOn(TimeZone zoneTime) {
        return TimeUtils.isNowOn(zoneTime, System.currentTimeMillis());
    }

    public static boolean isNowOn(LocalDateTime startTime, LocalDateTime stopTime, long now) {
        return TimeUtils.isNowOn(TimeUtils.toMilliseconds(startTime), TimeUtils.toMilliseconds(stopTime), now);
    }

    public static boolean isNowOn(LocalDateTime startTime, LocalDateTime stopTime) {
        return TimeUtils.isNowOn(TimeUtils.toMilliseconds(startTime), TimeUtils.toMilliseconds(stopTime), System.currentTimeMillis());
    }

    public static boolean isNowOn(long startTime, long stopTime) {
        return TimeUtils.isNowOn(startTime, stopTime, System.currentTimeMillis());
    }

    public static boolean isNowOn(long startTime, long stopTime, long now) {
        return startTime < now && stopTime > now;
    }

    public static boolean anyOneIsNowOn(List<TimeZone> zoneTimes) {
        return TimeUtils.anyOneIsNowOn(zoneTimes, System.currentTimeMillis());
    }

    public static boolean anyOneIsNowOn(List<TimeZone> zoneTimes, long now) {
        return zoneTimes.stream().anyMatch(zoneTime -> TimeUtils.isNowOn(zoneTime, now));
    }

    public static long randomDate(TimeZone timeZone) {
        return ThreadLocalRandom.current().nextLong(timeZone.getStartTime(), timeZone.getStopTime());
    }

    public static long randomDate(int year1, int month1, int day1, int year2, int month2, int day2) {
        long startTime = TimeUtils.toMilliseconds(LocalDateTime.of(year1, month1, day1, 0, 0));
        long stopTime = TimeUtils.toMilliseconds(LocalDateTime.of(year2, month2, day2, 0, 0));
        return ThreadLocalRandom.current().nextLong(startTime, stopTime);
    }

    public static String getAstrologyName(LocalDateTime birthday) {
        return TimeUtils.getAstrologyName(TimeUtils.from(birthday));
    }

    public static String getAstrologyName(LocalDate birthday) {
        return TimeUtils.getAstrologyName(TimeUtils.from(birthday));
    }

    public static String getMomentTime(Date date) {
        return TimeUtils.getMomentTime(TimeUtils.toMilliseconds(date));
    }

    public static String getMomentTime(LocalDate localDate) {
        return TimeUtils.getMomentTime(TimeUtils.toMilliseconds(localDate));
    }

    public static String getMomentTime(LocalDateTime localDateTime) {
        return TimeUtils.getMomentTime(TimeUtils.toMilliseconds(localDateTime));
    }

    public static String getMomentTime(long timeMillis) {
        long intervalMillis = System.currentTimeMillis() - timeMillis;
        if (intervalMillis < TimeUnit.MINUTES.toMillis(1L)) {
            return Math.max(1L, intervalMillis / TimeUnit.SECONDS.toMillis(1L)) + "\u79d2\u524d";
        }
        if (intervalMillis < TimeUnit.HOURS.toMillis(1L)) {
            return Math.max(1L, intervalMillis / TimeUnit.MINUTES.toMillis(1L)) + "\u5206\u949f\u524d";
        }
        if (intervalMillis < TimeUnit.DAYS.toMillis(1L)) {
            return Math.max(1L, intervalMillis / TimeUnit.HOURS.toMillis(1L)) + "\u5c0f\u65f6\u524d";
        }
        if (intervalMillis < TimeUnit.DAYS.toMillis(2L)) {
            return "\u6628\u5929";
        }
        if (intervalMillis < TimeUnit.DAYS.toMillis(30L)) {
            return Math.max(1L, intervalMillis / TimeUnit.DAYS.toMillis(1L)) + "\u5929\u524d";
        }
        if (intervalMillis < TimeUnit.DAYS.toMillis(365L)) {
            return Math.max(1L, intervalMillis / TimeUnit.DAYS.toMillis(30L)) + "\u6708\u524d";
        }
        return Math.max(1L, intervalMillis / TimeUnit.DAYS.toMillis(365L)) + "\u5e74\u524d";
    }

    public static String getAstrologyName(Date date) {
        int index = TimeUtils.getAstrologyByDate(date);
        if (index < 0 || index > 11) {
            return "\u672a\u77e5";
        }
        return ASTROLOGY_NAMES[index];
    }

    private static int getAstrologyByDate(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        int month = dateTime.getMonthOfYear();
        int day = dateTime.getDayOfMonth();
        if (month == 3 && day >= 21 || month == 4 && day <= 20) {
            return 0;
        }
        if (month == 4 || month == 5 && day <= 21) {
            return 1;
        }
        if (month == 5 || month == 6 && day <= 21) {
            return 2;
        }
        if (month == 6 || month == 7 && day <= 22) {
            return 3;
        }
        if (month == 7 || month == 8 && day <= 23) {
            return 4;
        }
        if (month == 8 || month == 9 && day <= 23) {
            return 5;
        }
        if (month == 9 || month == 10 && day <= 23) {
            return 6;
        }
        if (month == 10 || month == 11 && day <= 22) {
            return 7;
        }
        if (month == 11 || month == 12 && day <= 21) {
            return 8;
        }
        if (month == 12 || month == 1 && day <= 20) {
            return 9;
        }
        if (month == 1 || month == 2 && day <= 19) {
            return 10;
        }
        if (month == 2 || month == 3) {
            return 11;
        }
        return -1;
    }

    public static String getChineseZodiac(int year) {
        int index = (year - 2020) % 12;
        if (index >= 0) {
            return ZODIAC_NAMES[index];
        }
        return ZODIAC_NAMES[12 - -index];
    }

    public static int getAge(LocalDateTime birthday) {
        return TimeUtils.getAge(TimeUtils.from(birthday));
    }

    public static int getAge(LocalDate birthday) {
        return TimeUtils.getAge(TimeUtils.from(birthday.atStartOfDay()));
    }

    public static int getAge(Date birthday) {
        Calendar now = Calendar.getInstance();
        Calendar born = Calendar.getInstance();
        now.setTime(new Date());
        born.setTime(birthday);
        if (born.after(now)) {
            return 0;
        }
        int age = now.get(1) - born.get(1);
        if (now.get(6) < born.get(6)) {
            --age;
        }
        return age;
    }

    public static Date from(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static LocalDateTime from(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date from(LocalDate date) {
        return TimeUtils.from(date.atStartOfDay());
    }

    public static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String format(Date date) {
        return TimeUtils.format(date, PATTERN_DATETIME);
    }

    public static String format(long timestamp, String pattern) {
        return TimeUtils.format(new Date(timestamp), pattern);
    }

    public static String format(long timestamp) {
        return TimeUtils.format(timestamp, PATTERN_DATETIME);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return TimeUtils.format(localDateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalDateTime localDateTime) {
        return TimeUtils.format(localDateTime, PATTERN_DATETIME);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return localDateTime.format(dateTimeFormatter);
    }

    public static String format(LocalDate localDate, String pattern) {
        return TimeUtils.format(localDate, DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter) {
        return localDate.format(dateTimeFormatter);
    }

    public static String nowFormat(DateTimeFormatter formatter) {
        return TimeUtils.format(LocalDateTime.now(), formatter);
    }

    public static String nowFormat(String pattern) {
        return TimeUtils.nowFormat(DateTimeFormatter.ofPattern(pattern, Locale.getDefault()));
    }

    public static int dayGap(Date start, Date end) {
        return new Period(start.getTime(), end.getTime(), PeriodType.days()).getDays();
    }

    public static int dayGap(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end, PeriodType.days()).getDays();
    }

    public static int dayGap(long startTimestamp, long endTimestamp) {
        return new Period(startTimestamp, endTimestamp, PeriodType.days()).getDays();
    }

    public static Date plusDays(int days) {
        return DateTime.now().plusDays(days).toDate();
    }

    public static long thisMonthLastTimeMilli() {
        return TimeUtils.toMonthLastTimeMilli(System.currentTimeMillis());
    }

    public static long thisWeekFirstTimeMilli() {
        return TimeUtils.toWeekFirstTimeMilli(System.currentTimeMillis());
    }

    public static long thisWeekLastTimeMilli() {
        return TimeUtils.toWeekLastTimeMilli(System.currentTimeMillis());
    }

    public static long thisDailyFirstTimeMilli() {
        return TimeUtils.toDailyFirstTimeMilli(System.currentTimeMillis());
    }

    public static long thisDailyLastTimeMilli() {
        return TimeUtils.toDailyLastTimeMilli(System.currentTimeMillis());
    }

    public static long thisMonthFirstTimeMilli() {
        return TimeUtils.toMonthFirstTimeMilli(System.currentTimeMillis());
    }

    public static long toDailyFirstTimeMilli(long timestamp) {
        return TimeUtils.toDailyFirstTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toDailyFirstTimeMilli(long timestamp, ZoneId zoneId) {
        return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId)).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    public static long toDailyLastTimeMilli(long timestamp) {
        return TimeUtils.toDailyLastTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toDailyLastTimeMilli(long timestamp, ZoneId zoneId) {
        return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId)).atStartOfDay(zoneId).plusDays(1L).toInstant().toEpochMilli() - 1L;
    }

    public static long toWeekFirstTimeMilli(long timestamp) {
        return TimeUtils.toWeekFirstTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toWeekFirstTimeMilli(long timestamp, ZoneId zoneId) {
        return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId)).with(DayOfWeek.MONDAY).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    public static long toWeekLastTimeMilli(long timestamp) {
        return TimeUtils.toWeekLastTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toWeekLastTimeMilli(long timestamp, ZoneId zoneId) {
        return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId)).with(DayOfWeek.MONDAY).plusWeeks(1L).atStartOfDay(zoneId).toInstant().toEpochMilli() - 1L;
    }

    public static long toMonthFirstTimeMilli(long timestamp) {
        return TimeUtils.toMonthFirstTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toMonthFirstTimeMilli(long timestamp, ZoneId zoneId) {
        Clock clock = Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId);
        Month nextMonth = MonthDay.now(clock).getMonth();
        return LocalDate.now(clock).with(MonthDay.of(nextMonth, 1)).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    public static long toMonthLastTimeMilli(long timestamp) {
        return TimeUtils.toMonthLastTimeMilli(timestamp, ZoneId.systemDefault());
    }

    public static long toMonthLastTimeMilli(long timestamp, ZoneId zoneId) {
        Clock clock = Clock.fixed(Instant.ofEpochMilli(timestamp), zoneId);
        Month nextMonth = MonthDay.now(clock).getMonth();
        return LocalDate.now(clock).with(MonthDay.of(nextMonth, 1)).plusMonths(1L).atStartOfDay(zoneId).toInstant().toEpochMilli() - 1L;
    }

    public static String getStandardWeek(long timestamp) {
        return TimeUtils.format(new Date(timestamp), PATTERN_WEEK);
    }

    public static String getSimplifyWeek(long timestamp) {
        String standWeek = TimeUtils.getStandardWeek(timestamp);
        return "\u5468" + standWeek.substring(2);
    }

    public static String getAmiableTime() {
        return TimeUtils.getAmiableTime(System.currentTimeMillis());
    }

    public static String getAmiableTime(long timestamp) {
        LocalDateTime localDateTime = TimeUtils.toLocalDateTime(timestamp);
        int hour = localDateTime.getHour();
        if (hour <= 10) {
            return "\u65e9\u4e0a";
        }
        if (hour > 12 && hour <= 14) {
            return "\u4e2d\u5348";
        }
        if (hour > 14 && hour <= 18) {
            return "\u4e0b\u5348";
        }
        if (hour > 18) {
            return "\u665a\u4e0a";
        }
        return "\u65e9\u4e0a";
    }

    public static int getYmdInt() {
        return TimeUtils.getYmdInt(System.currentTimeMillis());
    }

    public static int getYmdInt(long timestamp) {
        return Integer.parseInt(TimeUtils.format(timestamp, PATTERN_YMD_INT));
    }

    public static long getTimeDelta(long oldTime, long newTime) {
        return newTime - oldTime;
    }

    public static long getTimeDelta(Date oldTime, Date newTime) {
        return TimeUtils.getTimeDelta(oldTime.getTime(), newTime.getTime());
    }

    public static long getTimeDelta(LocalDateTime oldTime, LocalDateTime newTime) {
        return TimeUtils.getTimeDelta(TimeUtils.from(oldTime), TimeUtils.from(newTime));
    }

    public static Duration getDuration(LocalDateTime d1, LocalDateTime d2) {
        return Duration.between(d1, d2);
    }

    public static LocalDate max(LocalDate ... localDates) {
        if (ArrayUtils.isEmpty((Object[])localDates)) {
            return null;
        }
        List<LocalDate> localDateList = Arrays.asList(localDates);
        Collections.sort(localDateList, Comparator.reverseOrder());
        return localDateList.get(0);
    }

    public static LocalDate min(LocalDate ... localDates) {
        if (ArrayUtils.isEmpty((Object[])localDates)) {
            return null;
        }
        List<LocalDate> localDateList = Arrays.asList(localDates);
        Collections.sort(localDateList, Comparator.naturalOrder());
        return localDateList.get(0);
    }
}

