/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import com.spring.boxes.dollar.StringUtils;
import java.util.Optional;

public class ValueUtils {
    public static char val(Character source) {
        return ValueUtils.val(source, '\u0000');
    }

    public static char val(Character source, char defaultVal) {
        return Optional.ofNullable(source).map(x -> Character.valueOf(x.charValue())).orElse(Character.valueOf(defaultVal)).charValue();
    }

    public static float val(Float source) {
        return ValueUtils.val(source, 0.0f);
    }

    public static float val(Float source, float defaultVal) {
        return Optional.ofNullable(source).map(x -> Float.valueOf(x.floatValue())).orElse(Float.valueOf(defaultVal)).floatValue();
    }

    public static double val(Double source) {
        return ValueUtils.val(source, 0.0);
    }

    public static double val(Double source, double defaultVal) {
        return Optional.ofNullable(source).map(x -> (double)x).orElse(defaultVal);
    }

    public static byte val(Byte source) {
        return ValueUtils.val(source, (byte)0);
    }

    public static byte val(Byte source, byte defaultVal) {
        return Optional.ofNullable(source).map(x -> (byte)x).orElse(defaultVal);
    }

    public static int val(Integer source) {
        return ValueUtils.val(source, 0);
    }

    public static int val(Integer source, int defaultVal) {
        return Optional.ofNullable(source).map(x -> (int)x).orElse(defaultVal);
    }

    public static boolean val(Boolean source) {
        return ValueUtils.val(source, false);
    }

    public static boolean val(Boolean source, boolean defaultVal) {
        return Optional.ofNullable(source).map(x -> (boolean)x).orElse(defaultVal);
    }

    public static long val(Long source) {
        return ValueUtils.val(source, 0L);
    }

    public static long val(Long source, long defaultVal) {
        return Optional.ofNullable(source).map(x -> (long)x).orElse(defaultVal);
    }

    public static String val(String source) {
        return ValueUtils.val(source, "");
    }

    public static String val(String source, String defaultVal) {
        return Optional.ofNullable(source).map(StringUtils::trimToEmpty).orElse(defaultVal);
    }
}

