/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar;

import cn.hutool.core.io.IoUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.google.common.collect.Maps;
import com.spring.boxes.dollar.JSONUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

public class WebUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    public static final int DEFAULT_MAX_AGE = -1;

    @Nullable
    public static HttpServletRequest getRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(x -> (ServletRequestAttributes)x).map(ServletRequestAttributes::getRequest).orElse(null);
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(x -> (ServletRequestAttributes)x).map(ServletRequestAttributes::getResponse).orElse(null);
    }

    @Nullable
    public static RequestAttributes getRequestAttributes() {
        return RequestContextHolder.getRequestAttributes();
    }

    @Nullable
    public static HttpHeaders getResponseHeaders(MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setPragma("no-cache");
        headers.setCacheControl("no-cache");
        headers.setExpires(0L);
        headers.setContentType(mediaType);
        return headers;
    }

    @Nullable
    public static String getCookieVal(String name) {
        return WebUtils.getCookieVal(WebUtils.getRequest(), name);
    }

    @Nullable
    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = org.springframework.web.util.WebUtils.getCookie((HttpServletRequest)request, (String)StringUtils.trim((String)name));
        return cookie != null ? cookie.getValue() : "";
    }

    public static void setCookie(String name, @Nullable String value) {
        WebUtils.setCookie(WebUtils.getResponse(), name, value, -1);
    }

    public static void setCookie(String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(WebUtils.getResponse(), name, value, maxAgeInSeconds);
    }

    public static void setCookie(String domain, String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(domain, "/", name, value, maxAgeInSeconds);
    }

    public static void setCookie(String domain, String path, String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(WebUtils.getResponse(), domain, path, name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value) {
        WebUtils.setCookie(response, name, value, -1);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(response, "", name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String domain, String name, @Nullable String value, int maxAgeInSeconds) {
        WebUtils.setCookie(response, domain, "/", name, value, maxAgeInSeconds);
    }

    public static void setCookie(HttpServletResponse response, String domain, String path, String name, @Nullable String value, int maxAgeInSeconds) {
        if (response == null) {
            return;
        }
        log.debug("[set cookie] domain:{}, path:{}, name:{}, value:{}, maxAgeInSeconds:{}", new Object[]{domain, path, name, value, maxAgeInSeconds});
        Cookie cookie = new Cookie(StringUtils.trim((String)name), value);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath(path);
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static void clearCookie(String key) {
        WebUtils.setCookie(WebUtils.getResponse(), key, null, 0);
    }

    public static void clearCookie(HttpServletResponse response, String key) {
        WebUtils.setCookie(response, key, null, 0);
    }

    public static HttpSession getSession() {
        return WebUtils.getRequest().getSession();
    }

    public static ModelAndView toView(String viewPath) {
        return WebUtils.toView(viewPath, Maps.newHashMap());
    }

    public static ModelAndView toView(String viewPath, Map context) {
        return new ModelAndView(viewPath, context);
    }

    public static RedirectView redirect(String uri) {
        return new RedirectView(uri);
    }

    public static String getRequestIP() {
        return Optional.ofNullable(WebUtils.getRequest()).map(x -> WebUtils.getRequestIP(x)).orElse("");
    }

    public static String getRequestToken(HttpServletRequest httpRequest, String tokenName) {
        return WebUtils.getRequestToken(httpRequest, tokenName, true, true);
    }

    public static String getRequestToken(HttpServletRequest httpRequest, String tokenName, boolean isHeader, boolean isParameter) {
        String token = Optional.ofNullable(org.springframework.web.util.WebUtils.getCookie((HttpServletRequest)httpRequest, (String)tokenName)).map(x -> x.getValue()).orElse("");
        if (StringUtils.isBlank((CharSequence)token) && isHeader) {
            token = httpRequest.getHeader(tokenName);
        }
        if (StringUtils.isBlank((CharSequence)token) && isParameter) {
            token = httpRequest.getParameter(tokenName);
        }
        return token;
    }

    public static String getRequestIP(HttpServletRequest request) {
        String ip = request.getHeader("X-Requested-For");
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtils.isBlank((CharSequence)ip) ? null : ip.split(",")[0];
    }

    public static void writeAttach(HttpServletResponse response, String filename, byte[] content) throws IOException, IOException {
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
        response.setContentType("application/octet-stream");
        IoUtil.write((OutputStream)response.getOutputStream(), (boolean)false, (byte[])content);
    }

    public static void writeJSON(HttpServletResponse response, Object object) {
        String content = JSONUtils.toJSON(object);
        ServletUtil.write((HttpServletResponse)response, (String)content, (String)"application/json;charset=UTF-8");
    }
}

