/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.enums;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import lombok.Generated;

public enum HashTypeEnum {
    MD5("MD5", Hashing.md5()),
    SHA_1("SHA-1", Hashing.sha1()),
    SHA_256("SHA-256", Hashing.sha256()),
    MURMUR3_128("MURMUR3_128", Hashing.murmur3_128());

    private final String label;
    private final HashFunction function;

    public static HashTypeEnum getHashType(String name) {
        if (MD5.getLabel().equalsIgnoreCase(name)) {
            return MD5;
        }
        if (SHA_1.getLabel().equalsIgnoreCase(name)) {
            return SHA_1;
        }
        if (SHA_256.getLabel().equalsIgnoreCase(name)) {
            return SHA_256;
        }
        if (MURMUR3_128.getLabel().equalsIgnoreCase(name)) {
            return MURMUR3_128;
        }
        return MURMUR3_128;
    }

    public static HashFunction getHashFunction(HashTypeEnum hashEnum) {
        if (MD5 == hashEnum) {
            return MD5.getFunction();
        }
        if (SHA_1 == hashEnum) {
            return SHA_1.getFunction();
        }
        if (SHA_256 == hashEnum) {
            return SHA_256.getFunction();
        }
        if (MURMUR3_128 == hashEnum) {
            return MURMUR3_128.getFunction();
        }
        return MURMUR3_128.getFunction();
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public HashFunction getFunction() {
        return this.function;
    }

    @Generated
    private HashTypeEnum(String label, HashFunction function) {
        this.label = label;
        this.function = function;
    }
}

