/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.spring.boxes.dollar.$;
import com.spring.boxes.dollar.JoiningUtils;
import com.spring.boxes.dollar.ShuntUtils;
import com.spring.boxes.dollar.enums.HashTypeEnum;
import com.spring.boxes.dollar.enums.ShuffleKey;
import com.spring.boxes.dollar.support.MoreStream;
import com.spring.boxes.dollar.term.AbView;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbTool.class);

    public static AbView.Output shuffle(AbView.Input input, AbView.SceneView scene) {
        if (null == input || $.isBlank(input.getSceneKey()) || MapUtils.isEmpty(input.getParam()) || !input.getParam().containsKey(input.getShuntKey())) {
            log.info("shuffle empty out! input: {}", (Object)input);
            return AbView.EMPTY_OUT;
        }
        if (null == scene || CollectionUtils.isEmpty(scene.getGroups())) {
            log.info("shuffle empty out! scene: {}", (Object)scene);
            return AbView.EMPTY_OUT;
        }
        if (!input.getSceneKey().equals(scene.getSceneKey())) {
            log.info("shuffle empty out! input: {}, scene:{}", (Object)input, (Object)scene);
            return AbView.EMPTY_OUT;
        }
        AbTool.compileExpressions(scene);
        List<AbView.SceneView.Item> items = AbTool.shuffle(scene, input.getParam());
        return new AbView.Output(items);
    }

    private static List<AbView.SceneView.Item> shuffle(AbView.SceneView scene, Map<String, Object> matchParam) {
        ArrayList items = Lists.newArrayList();
        for (AbView.SceneView.Group group : scene.getGroups()) {
            List<AbView.SceneView.Item> es = AbTool.shuffle(group, matchParam);
            items.addAll(es);
        }
        return items;
    }

    private static List<AbView.SceneView.Item> shuffle(AbView.SceneView.Group g, Map<String, Object> matchParam) {
        if (null == g || MapUtils.isEmpty(matchParam) || $.isBlank(g.getShuntKey()) || null == matchParam.get(g.getShuntKey()) || $.isBlank(String.valueOf(matchParam.get(g.getShuntKey()))) || CollectionUtils.isEmpty(g.getItems())) {
            return Lists.newArrayList();
        }
        String shuffleVal = String.valueOf(matchParam.get(g.getShuntKey()));
        List items = g.getItems().stream().sorted(Comparator.comparing(AbView.SceneView.Item::getItemWeight)).collect(Collectors.toList());
        ArrayList<AbView.SceneView.Item> list = new ArrayList<AbView.SceneView.Item>();
        if ($.isNotBlank(g.getExpressions()) && !AbTool.filterExpression(g.getCompiledExpression(), matchParam)) {
            return list;
        }
        long sum = items.stream().mapToLong(AbView.SceneView.Item::getItemWeight).sum();
        AtomicLong now = new AtomicLong();
        for (AbView.SceneView.Item e : items) {
            HashTypeEnum hashEnum = HashTypeEnum.getHashType(g.getShuntAlgorithm());
            int hashVal = Math.abs(HashTypeEnum.getHashFunction(hashEnum).newHasher().putString((CharSequence)shuffleVal, Charset.defaultCharset()).hash().asInt());
            if (e.getItemWeight() <= 0L) continue;
            now.addAndGet(e.getItemWeight());
            String config = String.format("%s;%s-%s;%s;%s;", sum, now.get() - e.getItemWeight(), now.get() - 1L, JoiningUtils.joinList(e.getWhiteList()), JoiningUtils.joinList(e.getBlackList()));
            if (!ShuntUtils.isOnFor(config, hashVal)) continue;
            list.add(e);
        }
        return MoreStream.distinct(list);
    }

    private static boolean filterExpression(Expression compiledExpressions, Map<String, Object> ft) {
        if (compiledExpressions != null) {
            try {
                return (Boolean)compiledExpressions.execute(ft);
            }
            catch (Exception e) {
                log.warn("\u6267\u884caviator\u8868\u8fbe\u5f0f\u5931\u8d25,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u7684\u914d\u7f6e\u548c\u5165\u53c2\u662f\u5426\u6b63\u786e,\u539f\u56e0:{} ", (Object)e.getCause(), (Object)e);
            }
        }
        return true;
    }

    @Deprecated
    private static boolean isItemWhiteList(String shuffleVal, AbView.SceneView.Item item) {
        if (null == item || $.isBlank(shuffleVal) || CollectionUtils.isEmpty(item.getWhiteList())) {
            return false;
        }
        return item.getWhiteList().contains(shuffleVal);
    }

    private static void compileExpressions(AbView.SceneView scene) {
        if (null == scene) {
            return;
        }
        if (CollectionUtils.isEmpty(scene.getGroups())) {
            return;
        }
        for (AbView.SceneView.Group group : scene.getGroups()) {
            if (!Objects.nonNull(group) || !StringUtils.isNotBlank((CharSequence)group.getExpressions())) continue;
            group.setCompiledExpression(AviatorEvaluator.compile((String)group.getExpressions(), (boolean)true));
        }
    }

    public static List<AbView.SceneView.Group> sceneGroup() {
        ArrayList groups = Lists.newArrayList();
        AbView.SceneView.Group group = new AbView.SceneView.Group();
        group.setSceneId(1L);
        group.setGroupId(1001L);
        group.setGroupName("\u5b9e\u9a8c\u5206\u7ec41");
        group.setShuntKey(ShuffleKey.USER_ID.getKey());
        group.setExpressions("(city_id==1||city_id==2||city_id==3)");
        group.setItems(AbTool.sceneItem());
        groups.add(group);
        return groups;
    }

    public static List<AbView.SceneView.Item> sceneItem() {
        ArrayList items = Lists.newArrayList();
        AbView.SceneView.Item item1 = new AbView.SceneView.Item();
        item1.setCarry((Map<String, String>)ImmutableMap.of((Object)"k1", (Object)String.valueOf(1), (Object)"k2", (Object)String.valueOf(2)));
        item1.setItemId(1L);
        item1.setItemName("\u5bf9\u7167\u7ec41");
        item1.setGroupId(1001L);
        item1.setItemWeight(30L);
        item1.setSceneId(1L);
        item1.setWhiteList(Lists.newArrayList((Object[])new String[]{"3"}));
        AbView.SceneView.Item item2 = new AbView.SceneView.Item();
        item2.setCarry((Map<String, String>)ImmutableMap.of((Object)"k333", (Object)String.valueOf(3)));
        item2.setItemId(2L);
        item2.setItemName("\u5bf9\u7167\u7ec42");
        item2.setItemWeight(70L);
        item2.setGroupId(1001L);
        item2.setSceneId(1L);
        items.add(item1);
        items.add(item2);
        return items;
    }
}

