/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.spring.boxes.dollar.support.ApiStatus;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ApiResult<T>
implements Serializable {
    private int status;
    private T data;
    private String message;

    public ApiResult() {
    }

    public ApiResult(ApiStatus status) {
        this(status, null);
    }

    public ApiResult(ApiStatus status, T data) {
        this(status.getStatus(), status.getMessage(), data);
    }

    public ApiResult(int status, String message, T data) {
        this.message = message;
        this.status = status;
        this.data = data;
    }

    public static ApiResult<?> success() {
        return ApiResult.success("");
    }

    public static <T> ApiResult<?> success(T data) {
        return new ApiResult<T>(ApiStatus.Status.SUCCESS, data);
    }

    public static ApiResult<?> failure() {
        return ApiResult.failure("");
    }

    public static ApiResult<?> failure(final String message) {
        ApiStatus status = new ApiStatus(){

            @Override
            public String getMessage() {
                return StringUtils.isBlank((CharSequence)message) ? ApiStatus.Status.FAILURE.getMessage() : message.trim();
            }

            @Override
            public int getStatus() {
                return FAILURE;
            }
        };
        return ApiResult.failure(status);
    }

    public static ApiResult<?> failure(ApiStatus status) {
        if (status.getStatus() == ApiStatus.SUCCESS) {
            throw new IllegalArgumentException("failure status cannot be 0. ");
        }
        return new ApiResult(status);
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiResult(status=" + this.getStatus() + ", data=" + this.getData() + ", message=" + this.getMessage() + ")";
    }
}

