/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import java.util.concurrent.Callable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ContextAwareCallable<T>
implements Callable<T> {
    private Callable<T> task;
    private RequestAttributes context;

    public ContextAwareCallable(Callable<T> task, RequestAttributes context) {
        this.task = task;
        this.context = context;
    }

    @Override
    public T call() throws Exception {
        if (this.context != null) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        }
        try {
            T t = this.task.call();
            return t;
        }
        finally {
            RequestContextHolder.resetRequestAttributes();
        }
    }
}

