/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.spring.boxes.dollar.support.ContextAwareCallable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.context.request.RequestContextHolder;

public class ContextAwarePoolExecutor
extends ThreadPoolTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextAwarePoolExecutor.class);

    public <T> Future<T> submit(@NonNull Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        return super.submit(new ContextAwareCallable<T>(task, RequestContextHolder.currentRequestAttributes()));
    }

    public <T> ListenableFuture<T> submitListenable(@NonNull Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        return super.submitListenable(new ContextAwareCallable<T>(task, RequestContextHolder.currentRequestAttributes()));
    }
}

