/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.spring.boxes.dollar.enums.TimePeriodEnum;
import java.util.Arrays;
import lombok.Generated;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrencyAmount {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CurrencyAmount.class);

    public static int getPeriodMod() {
        return CurrencyAmount.getPeriodMod(TimePeriodEnum.YEAR);
    }

    public static int getPeriodMod(TimePeriodEnum timeType) {
        return CurrencyAmount.getPeriodMod(DateTime.now(), timeType);
    }

    public static int getPeriodMod(DateTime now, TimePeriodEnum timeType) {
        if (TimePeriodEnum.DAY == timeType) {
            return now.getDayOfWeek();
        }
        if (TimePeriodEnum.WEEK == timeType) {
            return now.getWeekOfWeekyear();
        }
        if (TimePeriodEnum.MONTH == timeType) {
            return now.getMonthOfYear();
        }
        return now.getYear();
    }

    public static long getCurrentAmount(long balance0, long balance1, long balance2, int modVal) {
        Long[] balance = new Long[]{balance0, balance1, balance2};
        return CurrencyAmount.getCurrentAmount(balance, modVal);
    }

    public static long getCurrentAmount(Long[] balance, int cycleVal) {
        return balance[(cycleVal - 1) % 3] + balance[cycleVal % 3];
    }

    public static long getExpiringAmount(long balance0, long balance1, long balance2, int modVal) {
        Long[] balance = new Long[]{balance0, balance1, balance2};
        return CurrencyAmount.getExpiringAmount(balance, modVal);
    }

    public static long getExpiringAmount(Long[] balance, int modVal) {
        return balance[(modVal - 1) % 3];
    }

    public static Long[] clearExpiredAmount(long balance0, long balance1, long balance2, int modVal) {
        Long[] balance = new Long[]{balance0, balance1, balance2};
        return CurrencyAmount.clearExpiredAmount(balance, modVal);
    }

    public static Long[] clearExpiredAmount(Long[] balance, int modVal) {
        int index = (modVal - 2) % 3;
        if (index <= 0 || index > balance.length) {
            return balance;
        }
        balance[index] = 0L;
        return balance;
    }

    public static Long[] incrCurrentAmount(long balance0, long balance1, long balance2, int modVal, long deltaAmount) {
        Long[] balance = new Long[]{balance0, balance1, balance2};
        return CurrencyAmount.incrCurrentAmount(balance, modVal, deltaAmount);
    }

    public static Long[] incrCurrentAmount(Long[] balance, int cycleVal, long deltaAmount) {
        Long[] longArray = balance;
        int n = cycleVal % 3;
        Long.valueOf(longArray[n] + deltaAmount);
        return balance;
    }

    public static Long[] decrCurrentAmount(long balance0, long balance1, long balance2, int modVal, long deltaAmount) {
        Long[] balance = new Long[]{balance0, balance1, balance2};
        return CurrencyAmount.decrCurrentAmount(balance, modVal, deltaAmount);
    }

    public static Long[] decrCurrentAmount(Long[] balance, int modVal, long deltaAmount) {
        long currentTotal = CurrencyAmount.getCurrentAmount(balance, modVal);
        if (deltaAmount > currentTotal) {
            throw new IllegalArgumentException("\u4f59\u989d\u4e0d\u8db3");
        }
        int x = (modVal - 1) % 3;
        int y = modVal % 3;
        long decrX = Math.min(deltaAmount, balance[x]);
        long decrY = Math.max(deltaAmount - balance[x], 0L);
        Long[] longArray = balance;
        int n = x;
        Long.valueOf(longArray[n] - decrX);
        longArray = balance;
        n = y;
        Long.valueOf(longArray[n] - decrY);
        return balance;
    }

    protected static void incrAmount() {
        Object[] balance = new Long[]{0L, 0L, 0L};
        CurrencyAmount.incrCurrentAmount((Long[])balance, 1, 200L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 1) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 1));
        CurrencyAmount.clearExpiredAmount((Long[])balance, 1);
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
        CurrencyAmount.incrCurrentAmount((Long[])balance, 2, 350L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 2) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 2));
        CurrencyAmount.clearExpiredAmount((Long[])balance, 2);
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
        CurrencyAmount.incrCurrentAmount((Long[])balance, 3, 70L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 3) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 3));
        CurrencyAmount.clearExpiredAmount((Long[])balance, 3);
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
        CurrencyAmount.incrCurrentAmount((Long[])balance, 4, 100L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 4) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 4));
        CurrencyAmount.clearExpiredAmount((Long[])balance, 4);
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
    }

    protected static void decrAmount1() {
        Object[] balance = new Long[]{70L, 100L, 0L};
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 4) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 4));
        CurrencyAmount.decrCurrentAmount((Long[])balance, 4, 50L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 4) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 4));
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
    }

    protected static void decrAmount2() {
        Object[] balance = new Long[]{70L, 100L, 0L};
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 4) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 4));
        CurrencyAmount.decrCurrentAmount((Long[])balance, 4, 10L);
        System.out.println("\u5f53\u524d\u603b\u8d26: " + CurrencyAmount.getCurrentAmount((Long[])balance, 4) + ", \u5373\u5c06\u8fc7\u671f:" + CurrencyAmount.getExpiringAmount((Long[])balance, 4));
        System.out.println("\u91d1\u989d\u8bb0\u5f55: " + Arrays.toString(balance));
    }
}

