/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import cn.dev33.satoken.exception.NotLoginException;
import cn.hutool.core.util.StrUtil;
import com.spring.boxes.dollar.support.ApiException;
import com.spring.boxes.dollar.support.ApiResult;
import com.spring.boxes.dollar.support.ApiStatus;
import java.nio.file.AccessDeniedException;
import java.sql.SQLException;
import java.util.MissingFormatArgumentException;
import java.util.Objects;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.xml.bind.ValidationException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;

@ResponseBody
public class DefaultExceptionAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionAdvice.class);

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ApiResult<?> handleException(IllegalArgumentException e) {
        return this.handler(String.format("\u53c2\u6570\u9519\u8bef: %s", e.getLocalizedMessage()), e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ApiResult<?> noHandlerFoundExceptionHandler(NoHandlerFoundException ex) {
        log.warn("[noHandlerFoundExceptionHandler]", (Throwable)ex);
        return ApiResult.failure(String.format("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728:%s", ex.getRequestURL()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ApiResult<?> convertExceptionHandler(HttpMessageNotReadableException ex) {
        log.warn("[convertExceptionHandler]", (Throwable)ex);
        return ApiResult.failure(String.format("\u72b6\u6001\u8f6c\u7801\u5f02\u5e38: %s", Optional.of(ex).map(NestedRuntimeException::getRootCause).map(Throwable::getMessage).orElse("")));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ApiResult<?> constraintViolationExceptionHandler(ConstraintViolationException ex) {
        log.warn("[constraintViolationExceptionHandler]", (Throwable)ex);
        ConstraintViolation constraintViolation = (ConstraintViolation)ex.getConstraintViolations().iterator().next();
        String message = "\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e";
        if (StrUtil.isNotEmpty((CharSequence)constraintViolation.getMessage())) {
            message = constraintViolation.getMessage();
        }
        return ApiResult.failure(message);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ApiResult<?> validationException(ValidationException ex) {
        log.warn("[constraintViolationExceptionHandler]", (Throwable)ex);
        return ApiResult.failure(String.format("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7! %s", ex.getMessage()));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ApiResult<?> handleException(HttpMediaTypeNotSupportedException e) {
        return this.handler("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ApiResult<?> handleException(HttpRequestMethodNotSupportedException e) {
        return this.handler("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    public ApiResult<?> handleException(AccessDeniedException e) {
        return this.handler("\u6ca1\u6709\u6743\u9650", e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={NotLoginException.class})
    public ApiResult<?> handleException(NotLoginException e) {
        String message = e.getLocalizedMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            message = "\u4f1a\u8bdd\u5931\u6548,\u8bf7\u91cd\u65b0\u767b\u5f55";
        }
        int status = ApiStatus.Status.UNAUTHORIZED.getStatus();
        return new ApiResult<Object>(status, message, null);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={SQLException.class})
    public ApiResult<?> handleException(SQLException e) {
        return this.handler("SQLException\u5f02\u5e38", e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={ApiException.class})
    public ApiResult<?> handleException(ApiException e) {
        ApiStatus.Status status = e.getStatus();
        if (Objects.nonNull(status)) {
            return new ApiResult<Object>(status.getStatus(), e.getLocalizedMessage(), null);
        }
        return this.handler("\u4e1a\u52a1\u5f02\u5e38", e);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BindException.class})
    public ApiResult<?> paramExceptionHandler(BindException e) {
        ObjectError objectError = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        return ApiResult.failure(objectError.getDefaultMessage());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={MissingFormatArgumentException.class, MissingServletRequestParameterException.class})
    public ApiResult<?> handleException(MissingFormatArgumentException e) {
        return this.handler("\u53c2\u6570\u7f3a\u5931", e);
    }

    protected ApiResult<?> handler(String message, Exception e) {
        log.error(message, (Throwable)e);
        return ApiResult.failure(message);
    }
}

