/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.base.Predicates;
import com.google.common.util.concurrent.Uninterruptibles;
import com.spring.boxes.dollar.support.ThrowableRunnable;
import com.spring.boxes.dollar.support.ThrowableSupplier;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EasyRetry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EasyRetry.class);

    public static <X extends Throwable> void runWithRetry(int maxRetryTimes, long retryPeriod, ThrowableRunnable<X> func) throws X {
        EasyRetry.runWithRetry(maxRetryTimes, retryPeriod, func, (Predicate<Throwable>)Predicates.alwaysTrue());
    }

    public static <X extends Throwable> void runWithRetry(int maxRetryTimes, long retryPeriod, ThrowableRunnable<X> func, Predicate<Throwable> exceptionChecker) throws X {
        EasyRetry.supplyWithRetry(maxRetryTimes, retryPeriod, () -> {
            func.run();
            return null;
        }, exceptionChecker);
    }

    public static <T, X extends Throwable> T supplyWithRetry(int maxRetryTimes, long retryPeriod, ThrowableSupplier<T, X> func) throws X {
        return EasyRetry.supplyWithRetry(maxRetryTimes, retryPeriod, func, (Predicate<Throwable>)Predicates.alwaysTrue());
    }

    public static <T, X extends Throwable> T supplyWithRetry(int maxRetryTimes, long retryPeriod, ThrowableSupplier<T, X> func, Predicate<Throwable> exceptionChecker) throws X {
        int times = 0;
        while (true) {
            try {
                T result = func.get();
                log.debug("retry.success.{}", (Object)times);
                return result;
            }
            catch (Throwable e) {
                if (!exceptionChecker.test(e)) {
                    log.debug("retry.fail.{}", (Object)times);
                    throw e;
                }
                if (e instanceof Error) {
                    log.error("", e);
                }
                if (retryPeriod > 0L) {
                    Uninterruptibles.sleepUninterruptibly((long)retryPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (++times <= maxRetryTimes) {
                    log.warn("try to retry for exception:{}, retry times:{}", (Object)e, (Object)times);
                }
                Throwable lastThrowable = e;
                if (times <= maxRetryTimes) continue;
                throw lastThrowable;
            }
            break;
        }
    }

    @Generated
    private EasyRetry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

