/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class EnumWrap<T extends EnumType> {
    public abstract List<T> valueList();

    public T valueGet(int value) {
        return this.valueGet(value, null);
    }

    public T valueGet(int value, T defVal) {
        List<T> enums = this.valueList();
        for (EnumType em : enums) {
            if (em.getValue() != value) continue;
            return (T)em;
        }
        return defVal;
    }

    public T labelGet(String label) {
        return this.labelGet(label, null);
    }

    public T labelGet(String label, T defVal) {
        List<T> enums = this.valueList();
        for (EnumType em : enums) {
            if (!label.equalsIgnoreCase(em.getLabel())) continue;
            return (T)em;
        }
        return defVal;
    }

    public T nameGet(String name) {
        return this.nameGet(name, null);
    }

    public T nameGet(String name, T defVal) {
        List<T> enums = this.valueList();
        for (EnumType em : enums) {
            if (!StringUtils.trimToEmpty((String)name).toUpperCase().equals(em.getName())) continue;
            return (T)em;
        }
        return defVal;
    }

    public List<T> valueGet(List<Integer> values) {
        return ListUtils.emptyIfNull(values).stream().map(this::valueGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<T> labelGet(List<String> labels) {
        return ListUtils.emptyIfNull(labels).stream().filter(StringUtils::isNotBlank).map(this::labelGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<T> nameGet(List<String> names) {
        return ListUtils.emptyIfNull(names).stream().filter(StringUtils::isNotBlank).map(this::nameGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Integer> toValues(List<T> enums) {
        return ListUtils.emptyIfNull(enums).stream().map(x -> x.getValue()).collect(Collectors.toList());
    }

    public List<Integer> allValues() {
        return ListUtils.emptyIfNull(this.valueList()).stream().map(x -> x.getValue()).collect(Collectors.toList());
    }

    public List<String> toLabels(List<T> enums) {
        return ListUtils.emptyIfNull(enums).stream().map(EnumType::getLabel).collect(Collectors.toList());
    }

    public List<String> toNames(List<T> enums) {
        return ListUtils.emptyIfNull(enums).stream().map(EnumType::getName).collect(Collectors.toList());
    }

    public LinkedHashMap<Integer, String> toValueLabelPair() {
        LinkedHashMap<Integer, String> linkedHash = new LinkedHashMap<Integer, String>();
        ((List)Optional.ofNullable(this.valueList()).orElse(Lists.newArrayList())).forEach(x -> linkedHash.put(x.getValue(), x.getLabel()));
        return linkedHash;
    }

    public LinkedHashMap<String, String> toNameLabelPair() {
        LinkedHashMap<String, String> linkedHash = new LinkedHashMap<String, String>();
        ((List)Optional.ofNullable(this.valueList()).orElse(Lists.newArrayList())).forEach(x -> linkedHash.put(x.getName(), x.getLabel()));
        return linkedHash;
    }
}

