/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class MoreStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoreStream.class);

    public static <T> T getFirst(List<T> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static <E> E findAny(List<E> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(RandomUtils.nextInt((int)0, (int)list.size()));
    }

    public static boolean containsAny(Object source, Object ... targets) {
        return Arrays.asList(targets).contains(source);
    }

    public static boolean isAnyEmpty(Collection<?> ... collections) {
        return Arrays.stream(collections).anyMatch(CollectionUtils::isEmpty);
    }

    public static <T> List<T> filterList(Collection<T> from, Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(from)) {
            return new ArrayList();
        }
        return from.stream().filter(predicate).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <E> Set<E> ofImmutableSet(E ... es) {
        Objects.requireNonNull(es, "args es is null.");
        return Arrays.stream(es).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <E> List<E> ofImmutableList(E ... es) {
        Objects.requireNonNull(es, "args es is null.");
        return Arrays.stream(es).collect(Collectors.toList());
    }

    public static <T, K> Map<K, List<T>> groupBy(Collection<T> list, Function<? super T, ? extends K> func) {
        return CollectionUtils.emptyIfNull(list).stream().collect(Collectors.groupingBy(func));
    }

    public static <T> List<T> limit(List<T> list, int size) {
        return ListUtils.emptyIfNull(list).stream().limit(size).collect(Collectors.toList());
    }

    public static <T> List<T> distinct(List<T> list) {
        return ListUtils.emptyIfNull(list).stream().distinct().collect(Collectors.toList());
    }

    public static <T, R> List<T> distinct(Collection<T> from, Function<T, R> keyMapper) {
        if (CollectionUtils.isEmpty(from)) {
            return new ArrayList();
        }
        return MoreStream.distinct(from, keyMapper, (t1, t2) -> t1);
    }

    public static <T, R> List<T> distinct(Collection<T> from, Function<T, R> keyMapper, BinaryOperator<T> cover) {
        if (CollectionUtils.isEmpty(from)) {
            return new ArrayList();
        }
        return new ArrayList(MoreStream.convertMap(from, keyMapper, Function.identity(), cover).values());
    }

    public static <T, U> List<U> convertList(Collection<T> from, Function<T, U> func) {
        if (CollectionUtils.isEmpty(from)) {
            return new ArrayList();
        }
        return from.stream().map(func).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> List<U> convertList(Collection<T> from, Function<T, U> func, Predicate<T> filter) {
        if (CollectionUtils.isEmpty(from)) {
            return new ArrayList();
        }
        return from.stream().filter(filter).map(func).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> Set<U> convertSet(Collection<T> from, Function<T, U> func) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashSet();
        }
        return from.stream().map(func).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, U> Set<U> convertSet(Collection<T> from, Function<T, U> func, Predicate<T> filter) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashSet();
        }
        return from.stream().filter(filter).map(func).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> from, Function<T, K> keyFunc) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashMap();
        }
        return MoreStream.convertMap(from, keyFunc, Function.identity());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> from, Function<T, K> keyFunc, Supplier<? extends Map<K, T>> supplier) {
        if (CollectionUtils.isEmpty(from)) {
            return supplier.get();
        }
        return MoreStream.convertMap(from, keyFunc, Function.identity(), supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> from, Function<T, K> keyFunc, Function<T, V> valueFunc) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashMap();
        }
        return MoreStream.convertMap(from, keyFunc, valueFunc, (v1, v2) -> v1);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> from, Function<T, K> keyFunc, Function<T, V> valueFunc, BinaryOperator<V> mergeFunction) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashMap();
        }
        return MoreStream.convertMap(from, keyFunc, valueFunc, mergeFunction, HashMap::new);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> from, Function<T, K> keyFunc, Function<T, V> valueFunc, Supplier<? extends Map<K, V>> supplier) {
        if (CollectionUtils.isEmpty(from)) {
            return supplier.get();
        }
        return MoreStream.convertMap(from, keyFunc, valueFunc, (v1, v2) -> v1, supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> from, Function<T, K> keyFunc, Function<T, V> valueFunc, BinaryOperator<V> mergeFunction, Supplier<? extends Map<K, V>> supplier) {
        if (CollectionUtils.isEmpty(from)) {
            return new HashMap();
        }
        return from.stream().collect(Collectors.toMap(keyFunc, valueFunc, mergeFunction, supplier));
    }

    public static <T> List<T> randomList(Collection<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        ArrayList result = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object t = copy.get(RandomUtils.nextInt((int)0, (int)copy.size()));
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> randomList(List<T> list, int size) {
        ArrayList tmp = Lists.newArrayList(list);
        if (size == list.size()) {
            return tmp;
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            int index = RandomUtils.nextInt((int)0, (int)tmp.size());
            result.add(tmp.remove(index));
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> listMerge(Collection<T> ... coll) {
        if (ArrayUtils.getLength(coll) == 0) {
            return Lists.newArrayList();
        }
        ArrayList target = Lists.newArrayList();
        Arrays.stream(coll).filter(CollectionUtils::isNotEmpty).forEach(target::addAll);
        return target;
    }

    @SafeVarargs
    public static <K, V> Map<K, List<V>> keyMerged(Map<K, List<V>> target, Map<K, List<V>> ... maps) {
        Map base = MapUtils.emptyIfNull(target);
        if (ArrayUtils.isEmpty((Object[])maps)) {
            return base;
        }
        List<Map> adding = Arrays.stream(maps).map(MapUtils::emptyIfNull).collect(Collectors.toList());
        adding.forEach(x -> x.keySet().forEach(key -> base.merge(key, x.get(key), (v1, v2) -> Stream.of(v1, v2).flatMap(Collection::stream).collect(Collectors.toList()))));
        return base;
    }

    public static <T> boolean arrayContains(@Nullable T[] array, T element) {
        if (array == null) {
            return false;
        }
        return Arrays.stream(array).anyMatch(x -> ObjectUtils.nullSafeEquals((Object)x, (Object)element));
    }

    public static <T, R> List<R> toList(Collection<T> coll, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.emptyIfNull(coll).stream().map(mapper).collect(Collectors.toList());
    }

    public static <T, R> List<R> toListWithDistinct(Collection<T> coll, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.emptyIfNull(coll).stream().map(mapper).distinct().collect(Collectors.toList());
    }

    @SafeVarargs
    public static <K, V> Map<K, V> getMapValues(Map<K, V> map, K ... key) {
        if (MapUtils.isEmpty(map) || ArrayUtils.getLength(key) == 0) {
            return map;
        }
        HashMap target = new HashMap();
        Arrays.stream(key).filter(Objects::nonNull).forEach(e -> {
            Object value = map.get(e);
            if (Objects.nonNull(value)) {
                target.put(e, value);
            }
        });
        return target;
    }

    public static <K, V> V getMapValue(Map<K, V> map, K key) {
        if (Objects.isNull(key)) {
            return null;
        }
        return MapUtils.emptyIfNull(map).get(key);
    }

    public static <T, K, V> Map<K, V> toMap(Collection<T> coll, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return CollectionUtils.emptyIfNull(coll).stream().collect(Collectors.toMap(keyMapper, valueMapper, (o, n) -> o));
    }

    public static <K, V> ConcurrentHashMap<K, V> ofConcurrentHashMap(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        ConcurrentHashMap<Object, Object> keyValueMap = new ConcurrentHashMap<Object, Object>();
        for (int i = keysValues.length - 2; i >= 0; i -= 2) {
            Object key = keysValues[i];
            Object value = keysValues[i + 1];
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    public static <T> Stream<List<T>> partition(Stream<T> stream, int size) {
        Iterable iterable = () -> Iterators.partition(stream.iterator(), (int)size);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T, R> R supplyOne(@NonNull Supplier<T> supplier, @NonNull Function<T, ? extends R> mapper) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        T data = supplier.get();
        return Optional.ofNullable(data).map(mapper).orElse(null);
    }

    public static <T, R> List<R> supplyList(@NonNull Supplier<Collection<T>> supplier, @NonNull Function<T, ? extends R> mapper) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        Collection<T> list = supplier.get();
        return CollectionUtils.emptyIfNull(list).stream().map(mapper).collect(Collectors.toList());
    }

    public static <T> T getFuture(CompletableFuture<T> future, Consumer<? super Throwable> exceptionHandler) {
        return MoreStream.getFuture(future, exceptionHandler, null);
    }

    public static <T> T getFuture(CompletableFuture<T> future, T defaultValue) {
        return MoreStream.getFuture(future, e -> log.error(e.getLocalizedMessage(), e), defaultValue);
    }

    public static <T> T getFuture(CompletableFuture<T> future, Consumer<? super Throwable> exceptionHandler, T defaultValue) {
        return ((CompletableFuture)future.handle((result, ex) -> {
            if (ex != null) {
                exceptionHandler.accept((Throwable)ex);
                return defaultValue;
            }
            return result;
        })).join();
    }

    public static <X extends Throwable> void checkWithThrow(boolean expression, @NonNull Supplier<X> exception) throws X {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        if (!expression) {
            throw (Throwable)exception.get();
        }
    }

    public static <X extends Throwable> void checkWithThrow(boolean expression, Function<String, X> exception, String errorMessage, Object ... errorMessageArgs) throws X {
        if (!expression) {
            throw (Throwable)exception.apply(String.format(errorMessage, errorMessageArgs));
        }
    }

    public static <T> T getFuture(@Nonnull Future<? extends T> future, @Nonnull Duration duration) {
        Preconditions.checkNotNull((Object)duration);
        return MoreStream.getFuture(future, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public static <T> T getFuture(@Nonnull Future<? extends T> future, @Nonnegative long timeout, @Nonnull TimeUnit unit) {
        return MoreStream.getFuture(future, timeout, unit, false);
    }

    public static <T> T getFuture(@Nonnull Future<? extends T> future, @Nonnegative long timeout, @Nonnull TimeUnit unit, boolean cancelOnTimeout) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull(future);
        try {
            return (T)Uninterruptibles.getUninterruptibly(future, (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw new ExecutionError((Error)cause);
            }
            throw new UncheckedExecutionException(cause);
        }
        catch (TimeoutException e) {
            if (cancelOnTimeout) {
                future.cancel(false);
            }
            throw new UncheckedTimeoutException((Throwable)e);
        }
    }
}

