/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.JSONUtils;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Pagination<T>
implements Serializable {
    public static final Integer DEFAULT_PAGE_SIZE = 20;
    @ApiModelProperty(value="\u9875\u7801\u6570")
    private long page;
    @ApiModelProperty(value="\u6bcf\u9875\u5927\u5c0f")
    private long size;
    @ApiModelProperty(value="\u603b\u5171\u9875\u7801\u6570")
    private long pageTotal;
    @ApiModelProperty(value="\u8bb0\u5f55\u603b\u6570")
    private long rowTotal;
    @ApiModelProperty(value="\u5f53\u524d\u9875\u6570\u636e\u96c6")
    private List<T> items = Lists.newArrayList();
    private Map query;

    public static <T> Pagination<T> empty() {
        return new Pagination<T>();
    }

    public Pagination() {
        this(new ArrayList(), 0L, 1L);
    }

    public Pagination(List<T> list, long rowTotal, long page) {
        this.setPage(list, rowTotal, page, DEFAULT_PAGE_SIZE.intValue());
    }

    public Pagination(List<T> list, long rowTotal, long page, long size) {
        this.setPage(list, rowTotal, page, size);
    }

    private void setPage(List<T> list, long rowTotal, long page, long size) {
        long pageCount;
        if ((page = Math.abs(page)) >= (pageCount = (long)((int)(rowTotal - 1L)) / (size = Math.abs(size)) + 1L)) {
            page = pageCount;
        }
        this.setItems(list);
        this.setPageTotal(pageCount);
        this.setPage(page);
        this.setSize(size);
        this.setRowTotal(rowTotal);
    }

    public long getPageTotal() {
        if (this.getSize() > 0L) {
            return (this.getRowTotal() - 1L) / this.getSize() + 1L;
        }
        return 0L;
    }

    public boolean isFirstPage() {
        return 1L == this.getPage();
    }

    public boolean isLastPage() {
        return this.getPage() == this.getPageTotal();
    }

    public boolean isNextPage() {
        return this.getPageTotal() > 1L && this.getPage() < this.getPageTotal();
    }

    public boolean isPrePage() {
        return this.getPageTotal() > 1L && this.getPage() > 1L;
    }

    public String toString() {
        return JSONUtils.toJSON(this);
    }

    @Generated
    public long getPage() {
        return this.page;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getRowTotal() {
        return this.rowTotal;
    }

    @Generated
    public List<T> getItems() {
        return this.items;
    }

    @Generated
    public Map getQuery() {
        return this.query;
    }

    @Generated
    public void setPage(long page) {
        this.page = page;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setPageTotal(long pageTotal) {
        this.pageTotal = pageTotal;
    }

    @Generated
    public void setRowTotal(long rowTotal) {
        this.rowTotal = rowTotal;
    }

    @Generated
    public void setItems(List<T> items) {
        this.items = items;
    }

    @Generated
    public void setQuery(Map query) {
        this.query = query;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getPageTotal() != other.getPageTotal()) {
            return false;
        }
        if (this.getRowTotal() != other.getRowTotal()) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Map this$query = this.getQuery();
        Map other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !((Object)this$query).equals(other$query));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $pageTotal = this.getPageTotal();
        result = result * 59 + (int)($pageTotal >>> 32 ^ $pageTotal);
        long $rowTotal = this.getRowTotal();
        result = result * 59 + (int)($rowTotal >>> 32 ^ $rowTotal);
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Map $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        return result;
    }
}

