/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.Pagination;
import java.util.List;
import java.util.Optional;
import org.springframework.util.Assert;

public class PaginationPlus {
    public static <T> Page<T> page(int page, int size) {
        return new Page((long)Math.abs(page), (long)Math.abs(size));
    }

    public static <T> Pagination<T> builder(IPage<T> page) {
        if (null == page) {
            return Pagination.empty();
        }
        return new Pagination(page.getRecords(), page.getTotal(), (int)page.getCurrent(), (int)page.getSize());
    }

    public static <T> Pagination<T> selectPagination(IService<T> service, int page, int size, QueryWrapper<T> wrapper) {
        Assert.notNull(service, (String)"\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(wrapper, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return PaginationPlus.builder(service.page(PaginationPlus.page(page, size), wrapper));
    }

    public static <T> List<T> items(IPage<T> page) {
        return Optional.ofNullable(page).map(IPage::getRecords).orElse(Lists.newArrayList());
    }

    public static <T> List<T> items(Pagination<T> pagination) {
        return Optional.ofNullable(pagination).map(Pagination::getItems).orElse(Lists.newArrayList());
    }

    public static <T> List<T> items(IService<T> service, int page, int size, QueryWrapper<T> wrapper) {
        Assert.notNull(service, (String)"\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(wrapper, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return PaginationPlus.items(service.page(PaginationPlus.page(page, size), wrapper));
    }
}

