/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.base.Preconditions;
import com.spring.boxes.dollar.ValueUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class PairKey {
    private static final String KEY_FORMAT = "%s:%s";

    public static long getId(String key) {
        String[] array = PairKey.validPairArray(key);
        return ValueUtils.val(Long.parseLong(array[1]));
    }

    public static String getType(String key) {
        String[] array = PairKey.validPairArray(key);
        return array[0];
    }

    public static Pair<String, Long> getPair(String key) {
        String[] array = PairKey.validPairArray(key);
        return Pair.of((Object)array[0], (Object)Long.parseLong(array[1]));
    }

    public static String getKey(String type, long id) {
        return String.format(KEY_FORMAT, type, id);
    }

    public static String[] validPairArray(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"\u8d26\u53f7\u9519\u8bef!type:id");
        String[] array = StringUtils.split((String)key, (String)":");
        Preconditions.checkArgument((ArrayUtils.getLength((Object)array) == 2 ? 1 : 0) != 0, (Object)"\u8d26\u53f7\u9519\u8bef!type:id");
        return array;
    }
}

