/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.TimeUtils;
import com.spring.boxes.dollar.enums.TimePeriodEnum;
import com.spring.boxes.dollar.term.TimeZone;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PunchRange {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PunchRange.class);

    public static String getPeriodPunchKey(long appId, long userId, TimePeriodEnum period, long timestamp) {
        if (TimePeriodEnum.WEEK == period) {
            long firstTimeMill = TimeUtils.toWeekFirstTimeMilli(timestamp);
            return PunchRange.getPatternPunchKey(appId, userId, firstTimeMill);
        }
        if (TimePeriodEnum.MONTH == period) {
            long firstTimeMill = TimeUtils.toMonthFirstTimeMilli(timestamp);
            return PunchRange.getPatternPunchKey(appId, userId, firstTimeMill);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d3b\u52a8\u5468\u671f");
    }

    public static String getPatternPunchKey(long appId, long userId, long timestamp) {
        return String.format("_p:punch:m:%s:%s:%s", timestamp, appId, userId);
    }

    public static List<Long> getDailyTimeMillis(TimePeriodEnum period, long timestamp) {
        ArrayList dailyTimestamp = Lists.newArrayList();
        TimeZone timeZone = PunchRange.getTimeZone(period, timestamp);
        for (long i = timeZone.getStartTime(); i <= timeZone.getStopTime(); i += TimeUnit.DAYS.toMillis(1L)) {
            dailyTimestamp.add(TimeUtils.toDailyFirstTimeMilli(i));
        }
        return dailyTimestamp;
    }

    public static TimeZone getTimeZone(TimePeriodEnum period, long timestamp) {
        if (TimePeriodEnum.WEEK == period) {
            long startTimestamp = TimeUtils.toWeekFirstTimeMilli(timestamp);
            long stopTimestamp = TimeUtils.toWeekLastTimeMilli(timestamp);
            return new TimeZone(startTimestamp, stopTimestamp);
        }
        if (TimePeriodEnum.MONTH == period) {
            long startTimestamp = TimeUtils.toMonthFirstTimeMilli(timestamp);
            long stopTimestamp = TimeUtils.toMonthLastTimeMilli(timestamp);
            return new TimeZone(startTimestamp, stopTimestamp);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d3b\u52a8\u5468\u671f");
    }

    @Generated
    private PunchRange() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

