/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.spring.boxes.dollar.term.RatePair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class RangRate {
    public static <ID> ID getRateValue(List<RatePair<ID>> itemRate) {
        HashMap itemRates = Maps.newHashMap();
        for (RatePair<ID> ratePair : itemRate) {
            itemRates.put(ratePair.getValue(), ratePair.getRate());
        }
        return RangRate.getRateValue(itemRates);
    }

    public static <ID> ID getRateValue(Map<ID, Integer> itemRate) {
        RangeMap<Integer, ID> rangeMap = RangRate.toRangeMap(itemRate);
        return RangRate.getRateValue(rangeMap);
    }

    public static <ID> ID getRateValue(RangeMap<Integer, ID> rateItem) {
        int winRange = (Integer)rateItem.span().upperEndpoint();
        int random = ThreadLocalRandom.current().nextInt(winRange);
        return (ID)rateItem.get((Comparable)Integer.valueOf(random));
    }

    @Beta
    public static <ID> RangeMap<Integer, ID> toRangeMap(Map<ID, Integer> itemRate) {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        AtomicInteger rateSum = new AtomicInteger(0);
        for (Map.Entry<ID, Integer> entry : itemRate.entrySet()) {
            int rate = entry.getValue();
            rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(rateSum.get()), (Comparable)Integer.valueOf(rateSum.addAndGet(rate))), entry.getKey());
        }
        return rangeMap;
    }

    public static void main(String[] args) {
        List itemList = Arrays.asList(new RatePair<String>(10, "001"), new RatePair<String>(65, "002"), new RatePair<String>(35, "003"));
        System.out.println((String)RangRate.getRateValue(itemList));
    }
}

