/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.TreeHandler;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class TreeFunction {
    public static <T extends TreeHandler<T>> List<T> tree(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList items = Lists.newArrayList();
        list.stream().filter(x -> x.isTreeRoot()).forEach(x -> items.add(x));
        for (TreeHandler item : items) {
            TreeFunction.tree(list, item);
        }
        return items;
    }

    private static <T extends TreeHandler<T>> void tree(List<T> list, T t) {
        String pid = t.getTreeId();
        ArrayList data = Lists.newArrayList();
        list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getTreeParentId()) && pid.equals(x.getTreeParentId())).forEach(x -> {
            data.add(x);
            TreeFunction.tree(list, x);
        });
        if (!data.isEmpty()) {
            t.setSubList(data);
        }
    }

    @Generated
    private TreeFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

